<?php
/**
 * UAGB Config.
 *
 * @package UAGB
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'UAGB_Config' ) ) {

	/**
	 * Class UAGB_Config.
	 */
	class UAGB_Config {

		/**
		 * Block Attributes
		 *
		 * @var block_attributes
		 */
		public static $block_attributes = null;

		/**
		 * Block Assets
		 *
		 * @var block_attributes
		 */
		public static $block_assets = null;


		/**
		 * Block Assets
		 *
		 * @since 1.23.0
		 * @var block_attributes
		 */
		public static $block_assets_css = null;

		/**
		 * Get Widget List.
		 *
		 * @since 0.0.1
		 *
		 * @return array The Widget List.
		 */
		public static function get_block_attributes() {

			if ( null === self::$block_attributes ) {
				self::$block_attributes = array(
					'uagb/advanced-heading'       => array(
						'slug'        => '',
						'title'       => __( 'Advanced Heading', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block lets you add a combination of a heading and a sub-heading with a separator in between.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'            => false,
							'headingAlign'            => 'center',
							'headingColor'            => '',
							'subHeadingColor'         => '',
							'separatorColor'          => '',
							'seperatorStyle'          => 'solid',
							'separatorHeight'         => '',
							'separatorWidth'          => '',
							'separatorWidthType'      => '%',
							'headFontFamily'          => '',
							'headLoadGoogleFonts'     => false,
							'headFontWeight'          => '',
							'headFontSubset'          => '',
							'headFontSize'            => '',
							'headFontSizeType'        => 'px',
							'headFontSizeTablet'      => '',
							'headFontSizeMobile'      => '',
							'headLineHeight'          => '',
							'headLineHeightType'      => 'em',
							'headLineHeightTablet'    => '',
							'headLineHeightMobile'    => '',
							'subHeadFontFamily'       => '',
							'subHeadLoadGoogleFonts'  => false,
							'subHeadFontWeight'       => '',
							'subHeadFontSubset'       => '',
							'subHeadFontSize'         => '',
							'subHeadFontSizeType'     => 'px',
							'subHeadFontSizeTablet'   => '',
							'subHeadFontSizeMobile'   => '',
							'subHeadLineHeight'       => '',
							'subHeadLineHeightType'   => 'em',
							'subHeadLineHeightTablet' => '',
							'subHeadLineHeightMobile' => '',
							'headSpace'               => 15,
							'separatorSpace'          => 15,
						),
					),
					'uagb/columns'                => array(
						'slug'        => '',
						'title'       => __( 'Advanced Columns', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block gives you advanced options to insert a number of columns within a single row.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'           => false,
							'block_id'               => '',
							'columns'                => '2',
							'align'                  => '',
							'vAlign'                 => '',
							'stack'                  => 'mobile',
							'topPadding'             => '20',
							'bottomPadding'          => '20',
							'leftPadding'            => '20',
							'rightPadding'           => '20',
							'topMargin'              => '0',
							'bottomMargin'           => '0',
							'topPaddingTablet'       => '',
							'bottomPaddingTablet'    => '',
							'leftPaddingTablet'      => '',
							'rightPaddingTablet'     => '',
							'topPaddingMobile'       => '',
							'bottomPaddingMobile'    => '',
							'leftPaddingMobile'      => '',
							'rightPaddingMobile'     => '',
							'topMarginMobile'        => '',
							'bottomMarginMobile'     => '',
							'topMarginTablet'        => '',
							'bottomMarginTablet'     => '',
							'contentWidth'           => 'theme',
							'width'                  => '900',
							'widthType'              => 'px',
							'tag'                    => 'section',
							'backgroundType'         => 'none',
							'backgroundImage'        => '',
							'backgroundPosition'     => 'center-center',
							'backgroundSize'         => 'cover',
							'backgroundRepeat'       => 'no-repeat',
							'backgroundAttachment'   => 'scroll',
							'backgroundVideo'        => '',
							'backgroundColor'        => '',
							'gradientColor1'         => '',
							'gradientColor2'         => '',
							'gradientType'           => 'linear',
							'gradientLocation1'      => '0',
							'gradientLocation2'      => '100',
							'gradientAngle'          => '0',
							'gradientPosition'       => 'center center',
							'backgroundOpacity'      => '',
							'backgroundVideoOpacity' => '50',
							'backgroundVideoColor'   => '',
							'backgroundImageColor'   => '',
							'borderStyle'            => 'none',
							'borderWidth'            => '1',
							'borderRadius'           => '',
							'borderColor'            => '',
							'columnGap'              => '10',
							'bottomType'             => 'none',
							'bottomColor'            => '#333',
							'bottomHeight'           => '',
							'bottomHeightTablet'     => '',
							'bottomHeightMobile'     => '',
							'bottomWidth'            => '',
							'topType'                => 'none',
							'topColor'               => '#333',
							'topHeight'              => '',
							'topHeightTablet'        => '',
							'topHeightMobile'        => '',
							'topWidth'               => '',
							'bottomFlip'             => '',
							'topFlip'                => '',
							'mobileMarginType'       => 'px',
							'tabletMarginType'       => 'px',
							'desktopMarginType'      => 'px',
							'mobilePaddingType'      => 'px',
							'tabletPaddingType'      => 'px',
							'desktopPaddingType'     => 'px',
							'boxShadowColor'         => '',
							'boxShadowHOffset'       => 0,
							'boxShadowVOffset'       => 0,
							'boxShadowBlur'          => '',
							'boxShadowSpread'        => '',
							'boxShadowPosition'      => 'outset',
							'gradientValue'          => '',
						),
					),
					'uagb/column'                 => array(
						'slug'        => '',
						'title'       => __( 'Column', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block is an immediate child of Advanced Columns.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'             => false,
							'block_id'                 => '',
							'topPadding'               => '',
							'bottomPadding'            => '',
							'leftPadding'              => '',
							'rightPadding'             => '',
							'topMargin'                => '',
							'bottomMargin'             => '',
							'leftMargin'               => '',
							'rightMargin'              => '',
							'topPaddingTablet'         => '',
							'bottomPaddingTablet'      => '',
							'leftPaddingTablet'        => '',
							'rightPaddingTablet'       => '',
							'topPaddingMobile'         => '',
							'bottomPaddingMobile'      => '',
							'leftPaddingMobile'        => '',
							'rightPaddingMobile'       => '',
							'topMarginMobile'          => '',
							'bottomMarginMobile'       => '',
							'leftMarginMobile'         => '',
							'rightMarginMobile'        => '',
							'topMarginTablet'          => '',
							'bottomMarginTablet'       => '',
							'leftMarginTablet'         => '',
							'rightMarginTablet'        => '',
							'colWidth'                 => '',
							'colWidthTablet'           => '',
							'colWidthMobile'           => '',
							'backgroundType'           => 'none',
							'backgroundImage'          => '',
							'backgroundPosition'       => 'center-center',
							'backgroundSize'           => 'cover',
							'backgroundRepeat'         => 'no-repeat',
							'backgroundAttachment'     => 'scroll',
							'backgroundColor'          => '',
							'gradientColor1'           => '',
							'gradientColor2'           => '',
							'gradientType'             => 'linear',
							'gradientLocation1'        => 0,
							'gradientLocation2'        => 100,
							'gradientAngle'            => 0,
							'backgroundOpacity'        => '',
							'backgroundImageColor'     => '',
							'borderStyle'              => 'none',
							'borderWidth'              => 1,
							'borderRadius'             => '',
							'borderColor'              => '',
							'align'                    => 'center',
							'alignMobile'              => '',
							'alignTablet'              => '',
							'mobileMarginType'         => 'px',
							'tabletMarginType'         => 'px',
							'desktopMarginType'        => 'px',
							'mobilePaddingType'        => 'px',
							'tabletPaddingType'        => 'px',
							'desktopPaddingType'       => 'px',
							'overlayType'              => 'color',
							'gradientOverlayColor1'    => '',
							'gradientOverlayColor2'    => '',
							'gradientOverlayType'      => 'linear',
							'gradientOverlayLocation1' => '0',
							'gradientOverlayLocation2' => '100',
							'gradientOverlayAngle'     => '0',
							'gradientValue'            => '',

						),
					),
					'uagb/blockquote'             => array(
						'slug'        => '',
						'title'       => __( 'Blockquote', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to display your Blockquote.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'             => false,
							'block_id '                => '',
							'skinStyle'                => 'border',
							'align'                    => 'left',
							'descColor'                => '',
							'descFontSize'             => '',
							'descFontSizeType'         => 'px',
							'descFontSizeTablet'       => '',
							'descFontSizeMobile'       => '',
							'descFontFamily'           => '',
							'descFontWeight'           => '',
							'descFontSubset'           => '',
							'descLineHeightType'       => 'em',
							'descLineHeight'           => '',
							'descLineHeightTablet'     => '',
							'descLineHeightMobile'     => '',
							'descLoadGoogleFonts'      => false,
							'descSpace'                => 20,
							'authorColor'              => '#888888',
							'authorFontSize'           => '',
							'authorFontSizeType'       => 'px',
							'authorFontSizeTablet'     => '',
							'authorFontSizeMobile'     => '',
							'authorFontFamily'         => '',
							'authorFontWeight'         => '',
							'authorFontSubset'         => '',
							'authorLineHeightType'     => 'em
							',
							'authorLineHeight'         => '',
							'authorLineHeightTablet'   => '',
							'authorLineHeightMobile'   => '',
							'authorLoadGoogleFonts'    => false,
							'authorSpace'              => 10,
							'authorImageWidth'         => 40,
							'authorImgBorderRadius'    => 100,
							'authorImgPosition'        => 'right',
							'stack'                    => 'tablet',
							'enableTweet'              => true,
							'iconView'                 => 'icon_text',
							'iconSkin'                 => 'link',
							'tweetLinkColor'           => '#1DA1F2',
							'tweetBtnColor'            => '#fff',
							'tweetBtnBgColor'          => '#1DA1F2',
							'tweetBtnHoverColor'       => '',
							'tweetBtnBgHoverColor'     => '#1DA1F2',
							'tweetBtnFontSize'         => 15,
							'tweetBtnFontSizeType'     => 'px',
							'tweetBtnFontSizeTablet'   => '',
							'tweetBtnFontSizeMobile'   => '',
							'tweetBtnFontFamily'       => '',
							'tweetBtnFontWeight'       => '',
							'tweetBtnFontSubset'       => '',
							'tweetBtnLineHeightType'   => 'em',
							'tweetBtnLineHeight'       => '',
							'tweetBtnLineHeightTablet' => '',
							'tweetBtnLineHeightMobile' => '',
							'tweetBtnLoadGoogleFonts'  => false,
							'tweetBtnHrPadding'        => 10,
							'tweetBtnVrPadding'        => 10,
							'tweetIconSpacing'         => 10,
							'borderColor'              => '#abb8c3',
							'borderStyle'              => 'solid',
							'borderWidth'              => 4,
							'borderGap'                => 15,
							'verticalPadding'          => '',
							'quoteStyle'               => 'style_1',
							'quoteColor'               => '#abb8c3',
							'quoteSize'                => 25,
							'quoteSizeType'            => 'px',
							'quoteSizeTablet'          => '',
							'quoteSizeMobile'          => '',
							'quoteTopMargin'           => '',
							'quoteBottomMargin'        => '',
							'quoteLeftMargin'          => '',
							'quoteRightMargin'         => 20,
							'quoteBorderRadius'        => 100,
							'quoteBgColor'             => '#333',
							'quoteHoverColor'          => '',
							'quoteBgHoverColor'        => '',
							'borderHoverColor'         => '',
							'iconTargetUrl'            => 'current',
							'customUrl'                => '',
							'iconShareVia'             => '',
							'quotePadding'             => 10,
							'quotePaddingType'         => 'px',
							'quotePaddingTablet'       => '',
							'quotePaddingMobile'       => '',
							'descriptionText'          => 'Click here to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
						),
					),
					'uagb/call-to-action'         => array(
						'slug'        => '',
						'title'       => __( 'Call To Action', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place an CTA along with a heading and description within a single block.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'          => false,
							'inheritFromTheme'      => false,
							'textAlign'             => 'left',
							'titleColor'            => '',
							'descColor'             => '',
							'ctaPosition'           => 'right',
							'titleTag'              => '',
							'titleFontSize'         => '',
							'titleFontSizeType'     => 'px',
							'titleFontSizeMobile'   => '',
							'titleFontSizeTablet'   => '',
							'titleFontFamily'       => '',
							'titleFontWeight'       => '',
							'titleFontSubset'       => '',
							'titleLineHeightType'   => 'em',
							'titleLineHeight'       => '',
							'titleLineHeightTablet' => '',
							'titleLineHeightMobile' => '',
							'titleLoadGoogleFonts'  => false,
							'descFontSize'          => '',
							'descFontSizeType'      => 'px',
							'descFontSizeMobile'    => '',
							'descFontSizeTablet'    => '',
							'descFontFamily'        => '',
							'descFontWeight'        => '',
							'descFontSubset'        => '',
							'descLineHeightType'    => 'em',
							'descLineHeight'        => '',
							'descLineHeightTablet'  => '',
							'descLineHeightMobile'  => '',
							'descLoadGoogleFonts'   => false,
							'titleSpace'            => 10,
							'descSpace'             => 10,
							'buttonAlign'           => 'top',
							'ctaTarget'             => false,
							'ctaIconPosition'       => 'after',
							'ctaIconSpace'          => 5,
							'ctaType'               => 'button',
							'ctaLink'               => '#',
							'ctaFontSize'           => '',
							'ctaFontSizeType'       => 'px',
							'ctaFontSizeMobile'     => '',
							'ctaFontSizeTablet'     => '',
							'ctaFontFamily'         => '',
							'ctaFontWeight'         => '',
							'ctaFontSubset'         => '',
							'ctaLoadGoogleFonts'    => false,
							'ctaBtnLinkColor'       => '#333',
							'ctaBgColor'            => 'transparent',
							'ctaBgHoverColor'       => 'transparent',
							'ctaBorderColor'        => '#333',
							'ctaBorderhoverColor'   => '',
							'ctaBorderStyle'        => 'solid',
							'ctaBtnVertPadding'     => 10,
							'ctaBtnHrPadding'       => 14,
							'ctaBorderWidth'        => 1,
							'ctaBorderRadius'       => 0,
							'stack'                 => 'tablet',
							'showTitle'             => true,
							'showDesc'              => true,
							'ctaLeftSpace'          => 5,
							'ctaRightSpace'         => 5,
							'contentWidth'          => 70,
							'ctaLinkHoverColor'     => '',
						),
					),
					'uagb/cf7-styler'             => array(
						'slug'        => '',
						'title'       => __( 'Contact Form 7 Styler', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to add and style your Contact Form 7 forms right in the Gutenberg editor.', 'ultimate-addons-for-gutenberg' ),
						'is_active'   => class_exists( 'WPCF7_ContactForm' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'block_id'                     => '',
							'align'                        => 'left',
							'formId'                       => '0',
							'fieldStyle'                   => 'box',
							'fieldHrPadding'               => 10,
							'fieldVrPadding'               => 10,
							'fieldBgColor'                 => '#fafafa',
							'fieldLabelColor'              => '#333',
							'fieldInputColor'              => '#333',
							'fieldBorderStyle'             => 'solid',
							'fieldBorderWidth'             => 1,
							'fieldBorderRadius'            => 0,
							'fieldBorderColor'             => '#eeeeee',
							'fieldBorderFocusColor'        => '',
							'buttonAlignment'              => 'left',
							'buttonVrPadding'              => 10,
							'buttonHrPadding'              => 25,
							'buttonTextColor'              => '#333',
							'buttonBgColor'                => 'transparent',
							'buttonTextHoverColor'         => '',
							'buttonBgHoverColor'           => '',
							'buttonBorderStyle'            => 'solid',
							'buttonBorderWidth'            => 1,
							'buttonBorderRadius'           => 0,
							'buttonBorderColor'            => '#333',
							'buttonBorderHoverColor'       => '',
							'fieldSpacing'                 => '',
							'fieldLabelSpacing'            => '',
							'labelFontSize'                => '',
							'labelFontSizeType'            => 'px',
							'labelFontSizeTablet'          => '',
							'labelFontSizeMobile'          => '',
							'labelFontFamily'              => '',
							'labelFontWeight'              => '',
							'labelFontSubset'              => '',
							'labelLineHeightType'          => 'px',
							'labelLineHeight'              => '',
							'labelLineHeightTablet'        => '',
							'labelLineHeightMobile'        => '',
							'labelLoadGoogleFonts'         => false,
							'inputFontSize'                => '',
							'inputFontSizeType'            => 'px',
							'inputFontSizeTablet'          => '',
							'inputFontSizeMobile'          => '',
							'inputFontFamily'              => '',
							'inputFontWeight'              => '',
							'inputFontSubset'              => '',
							'inputLineHeightType'          => 'px',
							'inputLineHeight'              => '',
							'inputLineHeightTablet'        => '',
							'inputLineHeightMobile'        => '',
							'inputLoadGoogleFonts'         => false,
							'buttonFontSize'               => '',
							'buttonFontSizeType'           => 'px',
							'buttonFontSizeTablet'         => '',
							'buttonFontSizeMobile'         => '',
							'buttonFontFamily'             => '',
							'buttonFontWeight'             => '',
							'buttonFontSubset'             => '',
							'buttonLineHeightType'         => 'px',
							'buttonLineHeight'             => '',
							'buttonLineHeightTablet'       => '',
							'buttonLineHeightMobile'       => '',
							'buttonLoadGoogleFonts'        => false,
							'enableOveride'                => true,
							'radioCheckSize'               => '',
							'radioCheckBgColor'            => '',
							'radioCheckSelectColor'        => '',
							'radioCheckLableColor'         => '',
							'radioCheckBorderColor'        => '#abb8c3',
							'radioCheckBorderWidth'        => '',
							'radioCheckBorderRadius'       => '',
							'radioCheckFontSize'           => '',
							'radioCheckFontSizeType'       => 'px',
							'radioCheckFontSizeTablet'     => '',
							'radioCheckFontSizeMobile'     => '',
							'radioCheckFontFamily'         => '',
							'radioCheckFontWeight'         => '',
							'radioCheckFontSubset'         => '',
							'radioCheckLineHeightType'     => 'px',
							'radioCheckLineHeight'         => '',
							'radioCheckLineHeightTablet'   => '',
							'radioCheckLineHeightMobile'   => '',
							'radioCheckLoadGoogleFonts'    => false,
							'validationMsgPosition'        => 'default',
							'validationMsgColor'           => '#ff0000',
							'validationMsgBgColor'         => '',
							'enableHighlightBorder'        => false,
							'highlightBorderColor'         => '#ff0000',
							'validationMsgFontSize'        => '',
							'validationMsgFontSizeType'    => 'px',
							'validationMsgFontSizeTablet'  => '',
							'validationMsgFontSizeMobile'  => '',
							'validationMsgFontFamily'      => '',
							'validationMsgFontWeight'      => '',
							'validationMsgFontSubset'      => '',
							'validationMsgLineHeightType'  => 'em',
							'validationMsgLineHeight'      => '',
							'validationMsgLineHeightTablet' => '',
							'validationMsgLineHeightMobile' => '',
							'validationMsgLoadGoogleFonts' => false,
							'successMsgColor'              => '',
							'successMsgBgColor'            => '',
							'successMsgBorderColor'        => '',
							'errorMsgColor'                => '',
							'errorMsgBgColor'              => '',
							'errorMsgBorderColor'          => '',
							'msgBorderSize'                => '',
							'msgBorderRadius'              => '',
							'msgVrPadding'                 => '',
							'msgHrPadding'                 => '',
							'msgFontSize'                  => '',
							'msgFontSizeType'              => 'px',
							'msgFontSizeTablet'            => '',
							'msgFontSizeMobile'            => '',
							'msgFontFamily'                => '',
							'msgFontWeight'                => '',
							'msgFontSubset'                => '',
							'msgLineHeightType'            => 'em',
							'msgLineHeight'                => '',
							'msgLineHeightTablet'          => '',
							'msgLineHeightMobile'          => '',
							'msgLoadGoogleFonts'           => false,
							'radioCheckBorderRadiusType'   => 'px',
							'msgBorderRadiusType'          => 'px',
							'fieldBorderRadiusType'        => 'px',
							'buttonBorderRadiusType'       => 'px',
						),
					),
					'uagb/content-timeline'       => array(
						'slug'        => '',
						'title'       => __( 'Content Timeline', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'The Timeline block lets you create beautiful timelines on your website.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-timeline-js' ),
						'attributes'  => array(
							'classMigrate'            => false,
							'align'                   => 'center',
							'headingColor'            => '',
							'subHeadingColor'         => '',
							'separatorBg'             => '#eee',
							'backgroundColor'         => '#eee',
							'separatorColor'          => '#eee',
							'separatorFillColor'      => '#61ce70',
							'separatorBorder'         => '#eee',
							'borderFocus'             => '#5cb85c',
							'horizontalSpace'         => 10,
							'verticalSpace'           => 15,
							'headFontSizeType'        => 'px',
							'headFontSize'            => '',
							'headFontSizeTablet'      => '',
							'headFontSizeMobile'      => '',
							'headFontFamily'          => '',
							'headFontWeight'          => '',
							'headFontSubset'          => '',
							'headLineHeightType'      => 'em',
							'headLineHeight'          => '',
							'headLineHeightTablet'    => '',
							'headLineHeightMobile'    => '',
							'headLoadGoogleFonts'     => false,
							'timelinAlignment'        => 'center',
							'arrowlinAlignment'       => 'center',
							'subHeadFontSizeType'     => 'px',
							'subHeadFontSize'         => '',
							'subHeadFontSizeTablet'   => '',
							'subHeadFontSizeMobile'   => '',
							'subHeadFontFamily'       => '',
							'subHeadFontWeight'       => '',
							'subHeadFontSubset'       => '',
							'subHeadLineHeightType'   => 'em',
							'subHeadLineHeight'       => '',
							'subHeadLineHeightTablet' => '',
							'subHeadLineHeightMobile' => '',
							'subHeadLoadGoogleFonts'  => false,
							'headSpace'               => 5,
							'separatorwidth'          => 3,
							'borderwidth'             => 0,
							'iconColor'               => '#333',
							'iconFocus'               => '#fff',
							'iconBgFocus'             => '#61ce70',
							'dateColor'               => '#333',
							'dateFontsizeType'        => 'px',
							'dateFontsize'            => '12',
							'dateFontsizeTablet'      => '',
							'dateFontsizeMobile'      => '',
							'dateFontFamily'          => '',
							'dateFontWeight'          => '',
							'dateFontSubset'          => '',
							'dateLineHeightType'      => 'em',
							'dateLineHeight'          => '',
							'dateLineHeightTablet'    => '',
							'dateLineHeightMobile'    => '',
							'dateLoadGoogleFonts'     => false,
							'connectorBgsize'         => 35,
							'dateBottomspace'         => 5,
							'borderRadius'            => 2,
							'bgPadding'               => 20,
							'iconSize'                => 12,
							'stack'                   => 'tablet',
						),
					),
					'uagb/content-timeline-child' => array(
						'slug'        => '',
						'title'       => __( 'Content Timeline Child', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'The Timeline block lets you create beautiful timelines on your website.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(
							'align'             => 'center',
							'headingColor'      => '',
							'subHeadingColor'   => '',
							'backgroundColor'   => '#eee',
							'borderFocus'       => '#5cb85c',
							'timelinAlignment'  => 'center',
							'arrowlinAlignment' => 'center',
							'headSpace'         => 5,
							'separatorwidth'    => 3,
							'borderwidth'       => 0,
							'connectorBgsize'   => 35,
							'dateBottomspace'   => 5,
							'borderRadius'      => 2,
							'bgPadding'         => 20,
							'iconSize'          => 12,
							'iconFocus'         => '#fff',
							'stack'             => 'tablet',
						),
					),
					'uagb/faq'                    => array(
						'slug'        => '',
						'title'       => __( 'FAQ - Schema', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you add FAQ or Accordion with automatically adding FAQ Schema to your page.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-faq-js' ),
						'attributes'  => array(
							'block_id'                     => '',
							'layout'                       => 'accordion',
							'inactiveOtherItems'           => true,
							'expandFirstItem'              => false,
							'enableSchemaSupport'          => false,
							'align'                        => 'left',
							'enableSeparator'              => false,
							'rowsGap'                      => 10,
							'columnsGap'                   => 10,
							'boxBgColor'                   => '#FFFFFF',
							'boxPaddingTypeMobile'         => 'px',
							'boxPaddingTypeTablet'         => 'px',
							'boxPaddingTypeDesktop'        => 'px',
							'vBoxPaddingMobile'            => 10,
							'hBoxPaddingMobile'            => 10,
							'vBoxPaddingTablet'            => 10,
							'hBoxPaddingTablet'            => 10,
							'vBoxPaddingDesktop'           => 10,
							'hBoxPaddingDesktop'           => 10,
							'borderStyle'                  => 'solid',
							'borderWidth'                  => 1,
							'borderRadius'                 => 2,
							'borderColor'                  => '#D2D2D2',
							'questionTextColor'            => '#313131',
							'questionTextActiveColor'      => '#656565',
							'questionPaddingTypeDesktop'   => 'px',
							'vquestionPaddingMobile'       => 10,
							'vquestionPaddingTablet'       => 10,
							'vquestionPaddingDesktop'      => 10,
							'hquestionPaddingMobile'       => 10,
							'hquestionPaddingTablet'       => 10,
							'hquestionPaddingDesktop'      => 10,
							'answerTextColor'              => '#313131',
							'answerPaddingTypeDesktop'     => 'px',
							'vanswerPaddingMobile'         => 10,
							'vanswerPaddingTablet'         => 10,
							'vanswerPaddingDesktop'        => 10,
							'hanswerPaddingMobile'         => 10,
							'hanswerPaddingTablet'         => 10,
							'hanswerPaddingDesktop'        => 10,
							'iconColor'                    => '',
							'iconActiveColor'              => '',
							'gapBtwIconQUestion'           => 10,
							'questionloadGoogleFonts'      => false,
							'answerloadGoogleFonts'        => false,
							'questionFontFamily'           => 'Default',
							'questionFontWeight'           => '',
							'questionFontSubset'           => '',
							'questionFontSize'             => '',
							'questionFontSizeType'         => 'px',
							'questionFontSizeTablet'       => '',
							'questionFontSizeMobile'       => '',
							'questionLineHeight'           => '',
							'questionLineHeightType'       => 'em',
							'questionLineHeightTablet'     => '',
							'questionLineHeightMobile'     => '',
							'answerFontFamily'             => 'Default',
							'answerFontWeight'             => '',
							'answerFontSubset'             => '',
							'answerFontSize'               => '',
							'answerFontSizeType'           => 'px',
							'answerFontSizeTablet'         => '',
							'answerFontSizeMobile'         => '',
							'answerLineHeight'             => '',
							'answerLineHeightType'         => 'em',
							'answerLineHeightTablet'       => '',
							'answerLineHeightMobile'       => '',
							'icon'                         => 'fas fa-plus',
							'iconActive'                   => 'fas fa-minus',
							'iconAlign'                    => 'row',
							'iconSize'                     => 12,
							'iconSizeMobile'               => 15,
							'iconSizeTablet'               => 15,
							'iconSizeType'                 => 'px',
							'columns'                      => 2,
							'tcolumns'                     => 2,
							'mcolumns'                     => 1,
							'schema'                       => '',
							'enableToggle'                 => true,
							'questionLeftPaddingTablet'    => 10,
							'questionBottomPaddingTablet'  => 10,
							'questionLeftPaddingDesktop'   => 10,
							'questionBottomPaddingDesktop' => 10,
							'questionLeftPaddingMobile'    => 10,
							'questionBottomPaddingMobile'  => 10,
						),
					),
					'uagb/faq-child'              => array(
						'slug'        => '',
						'title'       => __( 'FAQ - Schema Child', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you add single FAQ.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'extension'   => false,
						'attributes'  => array(
							'block_id'   => '',
							'question'   => '',
							'answer'     => '',
							'icon'       => 'fas fa-plus',
							'iconActive' => 'fas fa-minus',
							'layout'     => 'accordion',
						),
					),
					'uagb/gf-styler'              => array(
						'slug'        => '',
						'title'       => __( 'Gravity Form Styler', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to add and style your Gravity Forms right in the Gutenberg editor.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'is_active'   => class_exists( 'GFForms' ),
						'attributes'  => array(
							'block_id'                     => '',
							'align'                        => 'left',
							'enableAjax'                   => false,
							'enableTabSupport'             => false,
							'formTabIndex'                 => '0',
							'formId'                       => '0',
							'titleDescStyle'               => 'yes',
							'titleDescAlignment'           => 'left',
							'fieldStyle'                   => 'box',
							'fieldHrPadding'               => 10,
							'fieldVrPadding'               => 10,
							'fieldBgColor'                 => '#fafafa',
							'fieldLabelColor'              => '#333',
							'fieldInputColor'              => '#333',
							'fieldBorderStyle'             => 'solid',
							'fieldBorderWidth'             => 1,
							'fieldBorderRadius'            => 0,
							'fieldBorderColor'             => '#eeeeee',
							'fieldBorderFocusColor'        => '',
							'buttonAlignment'              => 'left',
							'buttonVrPadding'              => 10,
							'buttonHrPadding'              => 25,
							'buttonTextColor'              => '#333',
							'buttonBgColor'                => 'transparent',
							'buttonTextHoverColor'         => '',
							'buttonBgHoverColor'           => '',
							'buttonBorderStyle'            => 'solid',
							'buttonBorderWidth'            => 1,
							'buttonBorderRadius'           => 0,
							'buttonBorderColor'            => '#333',
							'buttonBorderHoverColor'       => '',
							'fieldSpacing'                 => '',
							'fieldLabelSpacing'            => '',
							'enableLabel'                  => false,
							'textAreaHeight'               => 'auto',
							'labelFontSize'                => '',
							'labelFontSizeType'            => 'px',
							'labelFontSizeTablet'          => '',
							'labelFontSizeMobile'          => '',
							'labelFontFamily'              => '',
							'labelFontWeight'              => '',
							'labelFontSubset'              => '',
							'labelLineHeightType'          => 'px',
							'labelLineHeight'              => '',
							'labelLineHeightTablet'        => '',
							'labelLineHeightMobile'        => '',
							'labelLoadGoogleFonts'         => false,
							'inputFontSize'                => '',
							'inputFontSizeType'            => 'px',
							'inputFontSizeTablet'          => '',
							'inputFontSizeMobile'          => '',
							'inputFontFamily'              => '',
							'inputFontWeight'              => '',
							'inputFontSubset'              => '',
							'inputLineHeightType'          => 'px',
							'inputLineHeight'              => '',
							'inputLineHeightTablet'        => '',
							'inputLineHeightMobile'        => '',
							'inputLoadGoogleFonts'         => false,
							'buttonFontSize'               => '',
							'buttonFontSizeType'           => 'px',
							'buttonFontSizeTablet'         => '',
							'buttonFontSizeMobile'         => '',
							'buttonFontFamily'             => '',
							'buttonFontWeight'             => '',
							'buttonFontSubset'             => '',
							'buttonLineHeightType'         => 'px',
							'buttonLineHeight'             => '',
							'buttonLineHeightTablet'       => '',
							'buttonLineHeightMobile'       => '',
							'buttonLoadGoogleFonts'        => false,
							'enableOveride'                => true,
							'radioCheckSize'               => '20',
							'radioCheckBgColor'            => '#fafafa',
							'radioCheckSelectColor'        => '',
							'radioCheckLableColor'         => '',
							'radioCheckBorderColor'        => '#cbcbcb',
							'radioCheckBorderWidth'        => '1',
							'radioCheckBorderRadius'       => '',
							'radioCheckFontSize'           => '',
							'radioCheckFontSizeType'       => 'px',
							'radioCheckFontSizeTablet'     => '',
							'radioCheckFontSizeMobile'     => '',
							'radioCheckFontFamily'         => '',
							'radioCheckFontWeight'         => '',
							'radioCheckFontSubset'         => '',
							'radioCheckLineHeightType'     => 'px',
							'radioCheckLineHeight'         => '',
							'radioCheckLineHeightTablet'   => '',
							'radioCheckLineHeightMobile'   => '',
							'radioCheckLoadGoogleFonts'    => false,
							'validationMsgColor'           => '#ff0000',
							'advancedValidationSettings'   => false,
							'highlightBorderColor'         => '#ff0000',
							'validationMsgFontSize'        => '',
							'validationMsgBgColor'         => '',
							'validationMsgFontSizeType'    => 'px',
							'validationMsgFontSizeTablet'  => '',
							'validationMsgFontSizeMobile'  => '',
							'validationMsgFontFamily'      => '',
							'validationMsgFontWeight'      => '',
							'validationMsgFontSubset'      => '',
							'validationMsgLineHeightType'  => 'em',
							'validationMsgLineHeight'      => '',
							'validationMsgLineHeightTablet' => '',
							'validationMsgLineHeightMobile' => '',
							'validationMsgLoadGoogleFonts' => false,
							'successMsgBorderColor'        => '',
							'errorMsgColor'                => '',
							'errorMsgBgColor'              => '',
							'errorMsgBorderColor'          => '',
							'msgBorderSize'                => '',
							'msgBorderRadius'              => '',
							'msgVrPadding'                 => '',
							'msgHrPadding'                 => '',
							'msgFontSize'                  => '',
							'msgFontSizeType'              => 'px',
							'msgFontSizeTablet'            => '',
							'msgFontSizeMobile'            => '',
							'msgFontFamily'                => '',
							'msgFontWeight'                => '',
							'msgFontSubset'                => '',
							'msgLineHeightType'            => 'em',
							'msgLineHeight'                => '',
							'msgLineHeightTablet'          => '',
							'msgLineHeightMobile'          => '',
							'msgLoadGoogleFonts'           => false,
							'radioCheckBorderRadiusType'   => 'px',
							'msgBorderRadiusType'          => 'px',
							'fieldBorderRadiusType'        => 'px',
							'buttonBorderRadiusType'       => 'px',
							'successMsgColor'              => '',
							'successMsgFontSize'           => '',
							'successMsgFontSizeType'       => 'px',
							'successMsgFontSizeTablet'     => '',
							'successMsgFontSizeMobile'     => '',
							'successMsgFontFamily'         => '',
							'successMsgFontWeight'         => '',
							'successMsgFontSubset'         => '',
							'successMsgLineHeightType'     => 'em',
							'successMsgLineHeight'         => '',
							'successMsgLineHeightTablet'   => '',
							'successMsgLineHeightMobile'   => '',
							'successMsgLoadGoogleFonts'    => false,
						),
					),
					'uagb/google-map'             => array(
						'slug'        => '',
						'title'       => __( 'Google Map', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place a Google Map Location.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'block_id' => '',
							'height'   => '300',
							'language' => 'en',
						),
					),
					'uagb/how-to'                 => array(
						'slug'        => '',
						'title'       => __( 'How-to Schema', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to design attractive How-to pages or articles with automatically adding How-to Schema to your page.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'block_id'                => '',
							'overallAlignment'        => 'left',
							'tools_count'             => 1,
							'material_count'          => 1,
							'tools'                   => '',
							'materials'               => '',
							'showTotaltime'           => true,
							'showEstcost'             => true,
							'showTools'               => true,
							'showMaterials'           => true,
							'mainimage'               => '',
							'imgSize'                 => 'thumbnail',
							'timeSpace'               => 5,
							'costSpace'               => 5,
							'time'                    => '30',
							'cost'                    => '65',
							'currencyType'            => ' USD',
							'headingAlign'            => 'left',
							'descriptionAlign'        => 'left',
							'headingColor'            => '',
							'showEstcostcolor'        => '',
							'showTotaltimecolor'      => '',
							'subHeadingColor'         => '',
							'headingTag'              => 'h3',
							'headSpace'               => 15,
							'headFontFamily'          => 'Default',
							'headFontWeight'          => '',
							'headFontSubset'          => '',
							'headFontSizeType'        => 'px',
							'headLineHeightType'      => 'em',
							'headFontSize'            => '',
							'headFontSizeTablet'      => '',
							'headFontSizeMobile'      => '',
							'headLineHeight'          => '',
							'headLineHeightTablet'    => '',
							'headLineHeightMobile'    => '',
							'subHeadFontFamily'       => 'Default',
							'subHeadFontWeight'       => '',
							'subHeadFontSubset'       => '',
							'subHeadFontSize'         => '',
							'subHeadFontSizeType'     => 'px',
							'subHeadFontSizeTablet'   => '',
							'subHeadFontSizeMobile'   => '',
							'subHeadLineHeight'       => '',
							'subHeadLineHeightType'   => 'em',
							'subHeadLineHeightTablet' => '',
							'subHeadLineHeightMobile' => '',
							'separatorSpace'          => 15,
							'headLoadGoogleFonts'     => false,
							'subHeadLoadGoogleFonts'  => false,
							'priceFontSizeType'       => 'px',
							'priceFontSize'           => '',
							'priceFontSizeTablet'     => '',
							'priceFontSizeMobile'     => '',
							'priceFontFamily'         => 'Default',
							'priceFontWeight'         => '',
							'priceFontSubset'         => '',
							'priceLineHeightType'     => 'em',
							'priceLineHeight'         => '',
							'priceLineHeightTablet'   => '',
							'priceLineHeightMobile'   => '',
							'priceLoadGoogleFonts'    => false,
							'row_gap'                 => 20,
							'step_gap'                => '',
							'schema'                  => '',
						),
					),
					'uagb/icon-list'              => array(
						'slug'        => '',
						'title'       => __( 'Icon List', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place an image or icon in a list format.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'     => false,
							'childMigrate'     => false,
							'align'            => 'left',
							'icon_count'       => '1',
							'icons'            => array(
								array(
									'label'               => __( 'Label #1', 'ultimate-addons-for-gutenberg' ),
									'image_icon'          => 'icon',
									'icon'                => 'fab fa-facebook',
									'image'               => '',
									'icon_color'          => '#3a3a3a',
									'icon_hover_color'    => '#3a3a3a',
									'icon_bg_color'       => '',
									'icon_bg_hover_color' => '',
									'icon_border_color'   => '',
									'icon_border_hover_color' => '',
									'label_color'         => '',
									'label_hover_color'   => '',
									'link'                => '#',
									'target'              => false,
								),
							),
							'gap'              => '10',
							'inner_gap'        => '15',
							'size'             => '16',
							'sizeType'         => 'px',
							'sizeMobile'       => '',
							'sizeTablet'       => '',
							'bgSize'           => '0',
							'border'           => '0',
							'borderRadius'     => '0',
							'fontSize'         => '',
							'fontSizeType'     => 'px',
							'fontSizeMobile'   => '',
							'fontSizeTablet'   => '',
							'lineHeight'       => '',
							'lineHeightType'   => 'em',
							'lineHeightMobile' => '',
							'lineHeightTablet' => '',
							'fontFamily'       => '',
							'fontWeight'       => '',
							'fontSubset'       => '',
							'loadGoogleFonts'  => false,
							'icon_layout'      => 'vertical',
							'stack'            => 'none',
						),
					),
					'uagb/icon-list-child'        => array(
						'slug'        => '',
						'title'       => __( 'Icon', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place an image or icon in a list format.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'extension'   => false,
						'attributes'  => array(
							'image_icon'              => 'icon',
							'icon'                    => 'fab fa-facebook',
							'image'                   => '',
							'icon_color'              => '#3a3a3a',
							'icon_hover_color'        => '#3a3a3a',
							'icon_bg_color'           => '',
							'icon_bg_hover_color'     => '',
							'icon_border_color'       => '',
							'icon_border_hover_color' => '',
							'label_color'             => '',
							'label_hover_color'       => '',
							'link'                    => '#',
							'target'                  => false,
						),
					),
					'uagb/info-box'               => array(
						'slug'        => '',
						'title'       => __( 'Info Box', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place an image or icon along with a heading and description within a single block.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'            => false,
							'inheritFromTheme'        => false,
							'headingAlign'            => 'center',
							'headingColor'            => '',
							'subHeadingColor'         => '',
							'prefixColor'             => '',
							'prefixFontSize'          => '',
							'prefixFontSizeType'      => 'px',
							'prefixFontSizeTablet'    => '',
							'prefixFontSizeMobile'    => '',
							'prefixFontFamily'        => '',
							'prefixFontWeight'        => '',
							'prefixFontSubset'        => '',
							'prefixLineHeightType'    => 'em',
							'prefixLineHeight'        => '',
							'prefixLineHeightTablet'  => '',
							'prefixLineHeightMobile'  => '',
							'prefixLoadGoogleFonts'   => false,
							'headFontSize'            => '',
							'headFontSizeType'        => 'px',
							'headFontSizeTablet'      => '',
							'headFontSizeMobile'      => '',
							'headFontFamily'          => '',
							'headFontWeight'          => '',
							'headFontSubset'          => '',
							'headLineHeightType'      => 'em',
							'headLineHeight'          => '',
							'headLineHeightTablet'    => '',
							'headLineHeightMobile'    => '',
							'headLoadGoogleFonts'     => false,
							'subHeadFontSize'         => '',
							'subHeadFontSizeType'     => 'px',
							'subHeadFontSizeTablet'   => '',
							'subHeadFontSizeMobile'   => '',
							'subHeadFontFamily'       => '',
							'subHeadFontWeight'       => '',
							'subHeadFontSubset'       => '',
							'subHeadLineHeightType'   => 'em',
							'subHeadLineHeight'       => '',
							'subHeadLineHeightTablet' => '',
							'subHeadLineHeightMobile' => '',
							'subHeadLoadGoogleFonts'  => false,
							'separatorWidth'          => '',
							'separatorHeight'         => '',
							'separatorWidthType'      => '%',
							'headSpace'               => '10',
							'separatorSpace'          => '10',
							'subHeadSpace'            => '10',
							'icon'                    => '',
							'iconColor'               => '#333',
							'iconSize'                => '40',
							'iconimgPosition'         => 'above-title',
							'block_id'                => '',
							'iconHover'               => '',
							'iconimgBorderRadius'     => '0',
							'seperatorStyle'          => 'solid',
							'seperatorWidth'          => '30',
							'seperatorColor'          => '#333',
							'seperatorThickness'      => '2',
							'ctaLinkColor'            => '#333',
							'ctaFontSize'             => '',
							'ctaFontSizeType'         => 'px',
							'ctaFontSizeMobile'       => '',
							'ctaFontSizeTablet'       => '',
							'ctaFontFamily'           => '',
							'ctaFontWeight'           => '',
							'ctaFontSubset'           => '',
							'ctaLoadGoogleFonts'      => false,
							'ctaBtnLinkColor'         => '#333',
							'ctaBgColor'              => 'transparent',
							'ctaBtnVertPadding'       => '10',
							'ctaBtnHrPadding'         => '14',
							'ctaBorderStyle'          => 'solid',
							'ctaBorderColor'          => '#333',
							'ctaBorderWidth'          => '1',
							'ctaBorderRadius'         => '0',
							'prefixSpace'             => '5',
							'iconLeftMargin'          => '5',
							'iconRightMargin'         => '10',
							'iconTopMargin'           => '5',
							'iconBottomMargin'        => '5',
							'imageSize'               => 'thumbnail',
							'imageWidthType'          => true,
							'imageWidth'              => '120',
							'seperatorSpace'          => '15',
							'ctaLinkHoverColor'       => '',
							'ctaBgHoverColor'         => '',
							'ctaBorderhoverColor'     => '',
							'ctaIconSpace'            => '5',
						),
					),
					'uagb/inline-notice'          => array(
						'slug'        => '',
						'title'       => __( 'Inline Notice', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you add an inline notice.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-inline-notice-js', 'uagb-cookie-lib' ),
						'attributes'  => array(
							'block_id'              => '',
							'c_id'                  => null,
							'cookies'               => false,
							'close_cookie_days'     => 1,
							'textColor'             => '',
							'titleColor'            => '',
							'noticeColor'           => '#FFD54F',
							'contentBgColor'        => '',
							'fontSize'              => '14',
							'icon'                  => 'fa fa-window-close',
							'noticeDismiss'         => '',
							'noticeDismissColor'    => '',
							'noticeAlignment'       => 'left',
							'titleFontFamily'       => 'Default',
							'titleFontWeight'       => '',
							'titleFontSubset'       => '',
							'titleFontSizeType'     => 'px',
							'titleLineHeightType'   => '',
							'titleFontSize'         => '',
							'titleFontSizeTablet'   => '',
							'titleFontSizeMobile'   => '',
							'titleLineHeight'       => '',
							'titleLineHeightTablet' => '',
							'titleLineHeightMobile' => '',
							'descFontFamily'        => 'Default',
							'descFontWeight'        => '',
							'descFontSubset'        => '',
							'descFontSize'          => '',
							'descFontSizeType'      => 'px',
							'descFontSizeTablet'    => '',
							'descFontSizeMobile'    => '',
							'descLineHeight'        => '',
							'descLineHeightType'    => '',
							'descLineHeightTablet'  => '',
							'descLineHeightMobile'  => '',
							'titleLoadGoogleFonts'  => '',
							'descLoadGoogleFonts'   => '',
							'titleHrPadding'        => 15,
							'titleVrPadding'        => 15,
							'contentHrPadding'      => 15,
							'contentVrPadding'      => 15,
							'layout'                => 'modern',
							'highlightWidth'        => 10,

						),
					),
					'uagb/marketing-button'       => array(
						'slug'        => '',
						'title'       => __( 'Marketing Button', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place a Marketing Button with small description.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'           => false,
							'block_id'               => '',
							'align'                  => 'center',
							'textAlign'              => 'center',
							'link'                   => '#',
							'linkTarget'             => false,
							'titleSpace'             => 0,
							'borderStyle'            => 'solid',
							'borderWidth'            => 1,
							'borderRadius'           => '',
							'borderColor'            => '#333',
							'borderHoverColor'       => '',
							'vPadding'               => 8,
							'hPadding'               => 20,
							'vPaddingMobile'         => '',
							'hPaddingMobile'         => '',
							'vPaddingTablet'         => '',
							'hPaddingTablet'         => '',
							'paddingType'            => 'px',
							'backgroundType'         => 'color',
							'backgroundColor'        => '#eeeeee',
							'backgroundHoverColor'   => '',
							'gradientColor1'         => '',
							'gradientColor2'         => '',
							'gradientType'           => 'linear',
							'gradientLocation1'      => 0,
							'gradientLocation2'      => 100,
							'gradientAngle'          => 0,
							'backgroundOpacity'      => '',
							'backgroundHoverOpacity' => '',
							'titleColor'             => '#333',
							'titleHoverColor'        => '',
							'iconColor'              => '#333',
							'iconHoverColor'         => '',
							'iconPosition'           => 'before',
							'prefixColor'            => '#333',
							'prefixHoverColor'       => '',
							'iconSpace'              => 10,
							'titleLoadGoogleFonts'   => false,
							'titleFontFamily'        => '',
							'titleFontWeight'        => '',
							'titleFontSubset'        => '',
							'titleFontSize'          => 20,
							'titleFontSizeType'      => 'px',
							'titleFontSizeTablet'    => 20,
							'titleFontSizeMobile'    => 20,
							'titleLineHeightType'    => 'em',
							'titleLineHeight'        => '',
							'titleLineHeightTablet'  => '',
							'titleLineHeightMobile'  => '',
							'titleTag'               => 'h6',
							'prefixLoadGoogleFonts'  => false,
							'prefixFontFamily'       => '',
							'prefixFontWeight'       => '',
							'prefixFontSubset'       => '',
							'prefixFontSize'         => 14,
							'prefixFontSizeType'     => 'px',
							'prefixFontSizeTablet'   => 14,
							'prefixFontSizeMobile'   => 14,
							'prefixLineHeightType'   => 'em',
							'prefixLineHeight'       => '',
							'prefixLineHeightTablet' => '',
							'prefixLineHeightMobile' => '',
							'iconFontSize'           => 20,
							'iconFontSizeType'       => 'px',
							'iconFontSizeTablet'     => 20,
							'iconFontSizeMobile'     => 20,
						),
					),
					'uagb/buttons'                => array(
						'slug'        => '',
						'title'       => __( 'Multi Buttons', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to add multiple buttons with a single block.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'    => false,
							'childMigrate'    => false,
							'block_id'        => '',
							'align'           => 'center',
							'btn_count'       => '2',
							'buttons'         => UAGB_Helper::get_button_defaults(),
							'gap'             => 10,
							'stack'           => 'none',
							'fontFamily'      => '',
							'fontWeight'      => '',
							'loadGoogleFonts' => false,
							'fontSubset'      => '',
						),
					),
					'uagb/buttons-child'          => array(
						'slug'        => '',
						'title'       => __( 'Button', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to style button.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'extension'   => false,
						'attributes'  => array(
							'inheritFromTheme' => false,
							'block_id'         => '',
							'label'            => '',
							'link'             => '',
							'opensInNewTab'    => false,
							'target'           => '',
							'size'             => '',
							'vPadding'         => 10,
							'hPadding'         => 14,
							'borderWidth'      => 1,
							'borderRadius'     => 2,
							'borderStyle'      => 'solid',
							'borderColor'      => '#333',
							'borderHColor'     => '',
							'color'            => '#333',
							'background'       => '',
							'hColor'           => '',
							'hBackground'      => '',
							'sizeType'         => 'px',
							'sizeMobile'       => '',
							'sizeTablet'       => '',
							'lineHeight'       => '',
							'lineHeightType'   => 'em',
							'lineHeightMobile' => '',
							'lineHeightTablet' => '',
							'icon'             => '',
							'iconPosition'     => 'after',
							'iconSpace'        => 8,
						),
					),
					'uagb/post-carousel'          => array(
						'slug'        => '',
						'title'       => __( 'Post Carousel', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches the blog posts you may have on your website and displays them in a carousel layout.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-slick-js', 'uagb-post-js', 'uagb-imagesloaded' ),
						'css_assets'  => array( 'uagb-slick-css' ),
						'attributes'  => array(
							'post_type'               => 'carousel',
							'inheritFromTheme'        => false,
							'align'                   => 'left',
							'rowGap'                  => '20',
							'columnGap'               => '20',
							'bgColor'                 => '#e4e4e4',
							'titleColor'              => '#3b3b3b',
							'titleTag'                => 'h3',
							'titleFontSize'           => '',
							'titleFontSizeType'       => 'px',
							'titleFontSizeMobile'     => '',
							'titleFontSizeTablet'     => '',
							'titleFontFamily'         => '',
							'titleFontWeight'         => '',
							'titleFontSubset'         => '',
							'titleLineHeightType'     => 'em',
							'titleLineHeight'         => '',
							'titleLineHeightTablet'   => '',
							'titleLineHeightMobile'   => '',
							'titleLoadGoogleFonts'    => false,
							'metaFontSize'            => '',
							'metaFontSizeType'        => 'px',
							'metaFontSizeMobile'      => '',
							'metaFontSizeTablet'      => '',
							'metaFontFamily'          => '',
							'metaFontWeight'          => '',
							'metaFontSubset'          => '',
							'metaLineHeightType'      => 'em',
							'metaLineHeight'          => '',
							'metaLineHeightTablet'    => '',
							'metaLineHeightMobile'    => '',
							'metaLoadGoogleFonts'     => false,
							'excerptFontSize'         => '',
							'excerptFontSizeType'     => 'px',
							'excerptFontSizeMobile'   => '',
							'excerptFontSizeTablet'   => '',
							'excerptFontFamily'       => '',
							'excerptFontWeight'       => '',
							'excerptFontSubset'       => '',
							'excerptLineHeightType'   => 'em',
							'excerptLineHeight'       => '',
							'excerptLineHeightTablet' => '',
							'excerptLineHeightMobile' => '',
							'excerptLoadGoogleFonts'  => false,
							'ctaFontSize'             => '',
							'ctaFontSizeType'         => 'px',
							'ctaFontSizeTablet'       => '',
							'ctaFontSizeMobile'       => '',
							'ctaFontFamily'           => '',
							'ctaFontWeight'           => '',
							'ctaFontSubset'           => '',
							'ctaLineHeightType'       => 'em',
							'ctaLineHeight'           => '',
							'ctaLineHeightTablet'     => '',
							'ctaLineHeightMobile'     => '',
							'ctaLoadGoogleFonts'      => false,
							'metaColor'               => '#777777',
							'excerptColor'            => '',
							'ctaColor'                => '#ffffff',
							'ctaBgColor'              => '#333333',
							'ctaHColor'               => '',
							'ctaBgHColor'             => '',
							'contentPadding'          => '20',
							'contentPaddingMobile'    => '',
							'btnVPadding'             => '5',
							'btnHPadding'             => '10',
							'ctaBottomSpace'          => '0',
							'imageBottomSpace'        => '15',
							'titleBottomSpace'        => '15',
							'metaBottomSpace'         => '15',
							'excerptBottomSpace'      => '25',
							'arrowSize'               => '20',
							'arrowColor'              => '#aaaaaa',
							'arrowDots'               => '',
							'arrowBorderSize'         => '1',
							'arrowBorderRadius'       => '0',
							'overlayOpacity'          => '50',
							'bgOverlayColor'          => '#ffffff',
							'ctaText'                 => __( 'Read More', 'ultimate-addons-for-gutenberg' ),
							'borderWidth'             => '1',
							'borderStyle'             => 'none',
							'borderColor'             => '',
							'borderHColor'            => '',
							'borderRadius'            => '0',
							'imgPosition'             => 'top',
							'layoutConfig'            => array(
								array( 'uagb/post-image' ),
								array( 'uagb/post-title' ),
								array( 'uagb/post-meta' ),
								array( 'uagb/post-excerpt' ),
								array( 'uagb/post-button' ),
							),
						),
					),
					'uagb/post-grid'              => array(
						'slug'        => '',
						'title'       => __( 'Post Grid', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches the blog posts you may have on your website and displays them in a grid layout.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'post_type'                   => 'grid',
							'inheritFromTheme'            => false,
							'align'                       => 'left',
							'rowGap'                      => '20',
							'columnGap'                   => '20',
							'bgColor'                     => '#e4e4e4',
							'titleColor'                  => '#3b3b3b',
							'titleTag'                    => 'h3',
							'titleFontSize'               => '',
							'titleFontSizeType'           => 'px',
							'titleFontSizeMobile'         => '',
							'titleFontSizeTablet'         => '',
							'titleFontFamily'             => '',
							'titleFontWeight'             => '',
							'titleFontSubset'             => '',
							'titleLineHeightType'         => 'em',
							'titleLineHeight'             => '',
							'titleLineHeightTablet'       => '',
							'titleLineHeightMobile'       => '',
							'titleLoadGoogleFonts'        => false,
							'metaFontSize'                => '',
							'metaFontSizeType'            => 'px',
							'metaFontSizeMobile'          => '',
							'metaFontSizeTablet'          => '',
							'metaFontFamily'              => '',
							'metaFontWeight'              => '',
							'metaFontSubset'              => '',
							'metaLineHeightType'          => 'em',
							'metaLineHeight'              => '',
							'metaLineHeightTablet'        => '',
							'metaLineHeightMobile'        => '',
							'metaLoadGoogleFonts'         => false,
							'excerptFontSize'             => '',
							'excerptFontSizeType'         => 'px',
							'excerptFontSizeMobile'       => '',
							'excerptFontSizeTablet'       => '',
							'excerptFontFamily'           => '',
							'excerptFontWeight'           => '',
							'excerptFontSubset'           => '',
							'excerptLineHeightType'       => 'em',
							'excerptLineHeight'           => '',
							'excerptLineHeightTablet'     => '',
							'excerptLineHeightMobile'     => '',
							'excerptLoadGoogleFonts'      => false,
							'ctaFontSize'                 => '',
							'ctaFontSizeType'             => 'px',
							'ctaFontSizeTablet'           => '',
							'ctaFontSizeMobile'           => '',
							'ctaFontFamily'               => '',
							'ctaFontWeight'               => '',
							'ctaFontSubset'               => '',
							'ctaLineHeightType'           => 'em',
							'ctaLineHeight'               => '',
							'ctaLineHeightTablet'         => '',
							'ctaLineHeightMobile'         => '',
							'ctaLoadGoogleFonts'          => false,
							'metaColor'                   => '#777777',
							'excerptColor'                => '',
							'ctaColor'                    => '#ffffff',
							'ctaBgColor'                  => '#333333',
							'ctaHColor'                   => '',
							'ctaBgHColor'                 => '',
							'contentPadding'              => '20',
							'contentPaddingMobile'        => '',
							'btnVPadding'                 => '5',
							'btnHPadding'                 => '10',
							'ctaBottomSpace'              => '0',
							'imageBottomSpace'            => '15',
							'titleBottomSpace'            => '15',
							'metaBottomSpace'             => '15',
							'excerptBottomSpace'          => '25',
							'overlayOpacity'              => '50',
							'bgOverlayColor'              => '#ffffff',
							'ctaText'                     => __( 'Read More', 'ultimate-addons-for-gutenberg' ),
							'borderWidth'                 => '1',
							'borderStyle'                 => 'none',
							'borderColor'                 => '',
							'borderHColor'                => '',
							'borderRadius'                => '0',
							'postPagination'              => '',
							'pageLimit'                   => '',
							'paginationBgActiveColor'     => '#e4e4e4',
							'paginationActiveColor'       => '#333333',
							'paginationBgColor'           => '#e4e4e4',
							'paginationColor'             => '#777777',
							'paginationMarkup'            => '',
							'paginationLayout'            => 'filled',
							'paginationBorderActiveColor' => '',
							'paginationBorderColor'       => '#333',
							'paginationBorderRadius'      => '',
							'paginationBorderSize'        => 1,
							'paginationSpacing'           => 20,
							'paginationAlignment'         => 'left',
							'paginationNextText'          => '« Previous',
							'paginationPrevText'          => 'Next »',
							'imgPosition'                 => 'top',
							'layoutConfig'                => array(
								array( 'uagb/post-image' ),
								array( 'uagb/post-title' ),
								array( 'uagb/post-meta' ),
								array( 'uagb/post-excerpt' ),
								array( 'uagb/post-button' ),
							),
						),
					),
					'uagb/post-masonry'           => array(
						'slug'        => '',
						'title'       => __( 'Post Masonry', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches the blog posts you may have on your website and displays them in a masonry layout.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-masonry', 'uagb-imagesloaded', 'uagb-post-js' ),
						'attributes'  => array(
							'post_type'                    => 'masonry',
							'postType'                     => 'post',
							'inheritFromTheme'             => false,
							'align'                        => 'left',
							'rowGap'                       => '20',
							'columnGap'                    => '20',
							'bgColor'                      => '#e4e4e4',
							'titleColor'                   => '#3b3b3b',
							'titleTag'                     => 'h3',
							'titleFontSize'                => '',
							'titleFontSizeType'            => 'px',
							'titleFontSizeMobile'          => '',
							'titleFontSizeTablet'          => '',
							'titleFontFamily'              => '',
							'titleFontWeight'              => '',
							'titleFontSubset'              => '',
							'titleLineHeightType'          => 'em',
							'titleLineHeight'              => '',
							'titleLineHeightTablet'        => '',
							'titleLineHeightMobile'        => '',
							'titleLoadGoogleFonts'         => false,
							'metaFontSize'                 => '',
							'metaFontSizeType'             => 'px',
							'metaFontSizeMobile'           => '',
							'metaFontSizeTablet'           => '',
							'metaFontFamily'               => '',
							'metaFontWeight'               => '',
							'metaFontSubset'               => '',
							'metaLineHeightType'           => 'em',
							'metaLineHeight'               => '',
							'metaLineHeightTablet'         => '',
							'metaLineHeightMobile'         => '',
							'metaLoadGoogleFonts'          => false,
							'excerptFontSize'              => '',
							'excerptFontSizeType'          => 'px',
							'excerptFontSizeMobile'        => '',
							'excerptFontSizeTablet'        => '',
							'excerptFontFamily'            => '',
							'excerptFontWeight'            => '',
							'excerptFontSubset'            => '',
							'excerptLineHeightType'        => 'em',
							'excerptLineHeight'            => '',
							'excerptLineHeightTablet'      => '',
							'excerptLineHeightMobile'      => '',
							'excerptLoadGoogleFonts'       => false,
							'ctaFontSize'                  => '',
							'ctaFontSizeType'              => 'px',
							'ctaFontSizeTablet'            => '',
							'ctaFontSizeMobile'            => '',
							'ctaFontFamily'                => '',
							'ctaFontWeight'                => '',
							'ctaFontSubset'                => '',
							'ctaLineHeightType'            => 'em',
							'ctaLineHeight'                => '',
							'ctaLineHeightTablet'          => '',
							'ctaLineHeightMobile'          => '',
							'ctaLoadGoogleFonts'           => false,
							'metaColor'                    => '#777777',
							'excerptColor'                 => '',
							'ctaColor'                     => '#ffffff',
							'ctaBgColor'                   => '#333333',
							'ctaHColor'                    => '',
							'ctaBgHColor'                  => '',
							'contentPadding'               => '20',
							'contentPaddingMobile'         => '',
							'btnVPadding'                  => '5',
							'btnHPadding'                  => '10',
							'ctaBottomSpace'               => '0',
							'imageBottomSpace'             => '15',
							'titleBottomSpace'             => '15',
							'metaBottomSpace'              => '15',
							'excerptBottomSpace'           => '25',
							'overlayOpacity'               => '50',
							'bgOverlayColor'               => '#ffffff',
							'ctaText'                      => __( 'Read More', 'ultimate-addons-for-gutenberg' ),
							'borderWidth'                  => '1',
							'borderStyle'                  => 'none',
							'borderColor'                  => '',
							'borderHColor'                 => '',
							'borderRadius'                 => '0',
							'paginationType'               => 'none',
							'paginationEventType'          => 'button',
							'buttonText'                   => 'Load More',
							'paginationAlign'              => 'center',
							'paginationTextColor'          => '',
							'paginationMasonryBgColor'     => '',
							'paginationBgHoverColor'       => '',
							'paginationTextHoverColor'     => '',
							'paginationMasonryBorderStyle' => 'solid',
							'paginationMasonryBorderWidth' => 1,
							'paginationMasonryBorderRadius' => 2,
							'paginationMasonryBorderColor' => '',
							'paginationFontSize'           => 13,
							'loaderColor'                  => '#0085ba',
							'loaderSize'                   => 18,
							'paginationButtonPaddingType'  => 'px',
							'vpaginationButtonPaddingMobile' => 8,
							'vpaginationButtonPaddingTablet' => 8,
							'vpaginationButtonPaddingDesktop' => 8,
							'hpaginationButtonPaddingMobile' => 12,
							'hpaginationButtonPaddingTablet' => 12,
							'hpaginationButtonPaddingDesktop' => 12,
							'imgPosition'                  => 'top',
							'layoutConfig'                 => array(
								array( 'uagb/post-image' ),
								array( 'uagb/post-title' ),
								array( 'uagb/post-meta' ),
								array( 'uagb/post-excerpt' ),
								array( 'uagb/post-button' ),
							),

						),
					),
					'uagb/masonry-gallery'        => array(
						'slug'        => '',
						'title'       => __( 'Masonry Gallery', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches the Core Gallery and displays them in a masonry layout.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => true,
						'js_assets'   => array(),
						'attributes'  => array(),
					),
					'uagb/post-title'             => array(
						'slug'        => '',
						'title'       => __( 'Post Title', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches the blog title.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
					),
					'uagb/post-button'            => array(
						'slug'        => '',
						'title'       => __( 'Post Button', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block display\'s a call to action button which links to the blogs page.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
					),
					'uagb/post-excerpt'           => array(
						'slug'        => '',
						'title'       => __( 'Post Excerpt', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches short description about a post.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
					),
					'uagb/post-meta'              => array(
						'slug'        => '',
						'title'       => __( 'Post Meta', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches post comments, author, publish date and categories data.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
					),
					'uagb/post-image'             => array(
						'slug'        => '',
						'title'       => __( 'Post Image', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block fetches posts feature image.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
					),
					'uagb/post-timeline'          => array(
						'slug'        => '',
						'title'       => __( 'Post Timeline', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'The Timeline block lets you create beautiful timelines of Posts on your website.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-timeline-js' ),
						'attributes'  => array(
							'align'                   => 'center',
							'headingColor'            => '',
							'subHeadingColor'         => '',
							'separatorBg'             => '#eee',
							'backgroundColor'         => '#eee',
							'separatorColor'          => '#eee',
							'separatorFillColor'      => '#61ce70',
							'separatorBorder'         => '#eee',
							'borderFocus'             => '#5cb85c',
							'horizontalSpace'         => 10,
							'verticalSpace'           => 15,
							'headFontSizeType'        => 'px',
							'headFontSize'            => '',
							'headFontSizeTablet'      => '',
							'headFontSizeMobile'      => '',
							'headFontFamily'          => '',
							'headFontWeight'          => '',
							'headFontSubset'          => '',
							'headLineHeightType'      => 'em',
							'headLineHeight'          => '',
							'headLineHeightTablet'    => '',
							'headLineHeightMobile'    => '',
							'headLoadGoogleFonts'     => false,
							'timelinAlignment'        => 'center',
							'arrowlinAlignment'       => 'center',
							'subHeadFontSizeType'     => 'px',
							'subHeadFontSize'         => '',
							'subHeadFontSizeTablet'   => '',
							'subHeadFontSizeMobile'   => '',
							'subHeadFontFamily'       => '',
							'subHeadFontWeight'       => '',
							'subHeadFontSubset'       => '',
							'subHeadLineHeightType'   => 'em',
							'subHeadLineHeight'       => '',
							'subHeadLineHeightTablet' => '',
							'subHeadLineHeightMobile' => '',
							'subHeadLoadGoogleFonts'  => false,
							'headSpace'               => 5,
							'contentSpace'            => 5,
							'authorSpace'             => 5,
							'separatorwidth'          => 3,
							'borderwidth'             => 0,
							'iconColor'               => '#333',
							'iconFocus'               => '#fff',
							'iconBgFocus'             => '#61ce70',
							'dateColor'               => '#333',
							'dateFontsizeType'        => 'px',
							'dateFontsize'            => 12,
							'dateFontsizeTablet'      => '',
							'dateFontsizeMobile'      => '',
							'dateFontFamily'          => '',
							'dateFontWeight'          => '',
							'dateFontSubset'          => '',
							'dateLineHeightType'      => 'em',
							'dateLineHeight'          => '',
							'dateLineHeightTablet'    => '',
							'dateLineHeightMobile'    => '',
							'dateLoadGoogleFonts'     => false,
							'connectorBgsize'         => 35,
							'dateBottomspace'         => 5,
							'borderRadius'            => 2,
							'bgPadding'               => 20,
							'contentPadding'          => 10,
							'iconSize'                => 12,
							'stack'                   => 'tablet',
							'ctaColor'                => '#fff',
							'authorColor'             => '#333',
							'ctaFontSizeType'         => 'px',
							'ctaFontSize'             => '',
							'ctaFontSizeTablet'       => '',
							'ctaFontSizeMobile'       => '',
							'ctaFontFamily'           => '',
							'ctaFontWeight'           => '',
							'ctaFontSubset'           => '',
							'ctaLineHeightType'       => 'em',
							'ctaLineHeight'           => '',
							'ctaLineHeightTablet'     => '',
							'ctaLineHeightMobile'     => '',
							'ctaLoadGoogleFonts'      => false,
							'authorFontSizeType'      => 'px',
							'authorFontSize'          => 11,
							'authorFontSizeTablet'    => '',
							'authorFontSizeMobile'    => '',
							'authorFontFamily'        => '',
							'authorFontWeight'        => '',
							'authorFontSubset'        => '',
							'authorLineHeightType'    => 'em',
							'authorLineHeight'        => '',
							'authorLineHeightTablet'  => '',
							'authorLineHeightMobile'  => '',
							'authorLoadGoogleFonts'   => false,
							'ctaBackground'           => '#333',
						),
					),
					'uagb/restaurant-menu'        => array(
						'slug'        => '',
						'title'       => __( 'Price List', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to add attractive Price List.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'          => false,
							'block_id'              => '',
							'headingAlign'          => 'left',
							'descColor'             => '#333',
							'priceColor'            => '#888888',
							'titleColor'            => '#333',
							'imagePosition'         => 'top',
							'imageAlignment'        => 'top',
							'titleFontSize'         => '',
							'titleFontSizeType'     => 'px',
							'titleFontSizeMobile'   => '',
							'titleFontSizeTablet'   => '',
							'titleFontFamily'       => '',
							'titleFontWeight'       => '',
							'titleFontSubset'       => '',
							'titleLineHeightType'   => 'em',
							'titleLineHeight'       => '',
							'titleLineHeightTablet' => '',
							'titleLineHeightMobile' => '',
							'titleLoadGoogleFonts'  => false,
							'priceFontSize'         => '',
							'priceFontSizeType'     => 'px',
							'priceFontSizeMobile'   => '',
							'priceFontSizeTablet'   => '',
							'priceFontFamily'       => '',
							'priceFontWeight'       => '',
							'priceFontSubset'       => '',
							'priceLineHeightType'   => 'em',
							'priceLineHeight'       => '',
							'priceLineHeightTablet' => '',
							'priceLineHeightMobile' => '',
							'priceLoadGoogleFonts'  => false,
							'descFontSize'          => '',
							'descFontSizeType'      => 'px',
							'descFontSizeMobile'    => '',
							'descFontSizeTablet'    => '',
							'descFontFamily'        => '',
							'descFontWeight'        => '',
							'descFontSubset'        => '',
							'descLineHeightType'    => 'em',
							'descLineHeight'        => '',
							'descLineHeightTablet'  => '',
							'descLineHeightMobile'  => '',
							'descLoadGoogleFonts'   => false,
							'priceSpace'            => 5,
							'descSpace'             => 15,
							'titleSpace'            => 10,
							'imgVrPadding'          => 0,
							'imgHrPadding'          => 0,
							'imgTopPadding'         => 0,
							'imgBottomPadding'      => 0,
							'iconImage'             => '',
							'imageSize'             => 'medium',
							'imageWidth'            => '',
							'columns'               => 2,
							'tcolumns'              => 2,
							'mcolumns'              => 1,
							'rowGap'                => 10,
							'columnGap'             => 10,
							'contentHrPadding'      => 5,
							'contentVrPadding'      => 5,
							'seperatorStyle'        => 'dashed',
							'seperatorWidth'        => '100',
							'seperatorThickness'    => '1',
							'seperatorColor'        => '#b2b4b5',
						),
					),
					'uagb/review'                 => array(
						'slug'        => '',
						'title'       => __( 'Review Schema', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you to add a review for various items with schema support.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'block_id'                => '',
							'enableSchema'            => '',
							'overallAlignment'        => 'left',
							'authorName'              => '',
							'itemName'                => '',
							'description'             => '',
							'imgID'                   => '',
							'imgAlt'                  => '',
							'imgURL'                  => '',
							'items'                   => '',
							'parts'                   => '',
							'starCount'               => '',
							'summaryTitle'            => '',
							'summaryDescription'      => '',
							'inactiveStarColor'       => '',
							'activeStarColor'         => '',
							'titleAlign'              => '',
							'authorAlign'             => '',
							'descriptionAlign'        => '',
							'sku'                     => '',
							'identifier'              => '',
							'identifierType'          => '',
							'offerType'               => '',
							'offerCurrency'           => '',
							'offerStatus'             => '',
							'offerPrice'              => '',
							'offerExpiry'             => '',
							'datepublish'             => '',
							'ctaLink'                 => '',
							'ctaTarget'               => '',
							'author'                  => '',
							'brand'                   => '',
							'rTitle'                  => '',
							'rContent'                => '',
							'rAuthor'                 => '',
							'headingTag'              => '',
							'mainimage'               => '',
							'imgSize'                 => '',
							'showFeature'             => '',
							'starColor'               => '',
							'selectedStars'           => '',
							'descColor'               => '',
							'titleColor'              => '',
							'contentColor'            => '',
							'headFontSize'            => '',
							'headFontSizeType'        => 'px',
							'headFontSizeTablet'      => '',
							'headFontSizeMobile'      => '',
							'headFontFamily'          => '',
							'headFontWeight'          => '',
							'headFontSubset'          => '',
							'headLineHeightType'      => 'em',
							'headLineHeight'          => '',
							'headLineHeightTablet'    => '',
							'headLineHeightMobile'    => '',
							'headLoadGoogleFonts'     => false,
							'subHeadFontSize'         => '',
							'subHeadFontSizeType'     => 'px',
							'subHeadFontSizeTablet'   => '',
							'subHeadFontSizeMobile'   => '',
							'subHeadFontFamily'       => '',
							'subHeadFontWeight'       => '',
							'subHeadFontSubset'       => '',
							'subHeadLineHeightType'   => 'em',
							'subHeadLineHeight'       => '',
							'subHeadLineHeightTablet' => '',
							'subHeadLineHeightMobile' => '',
							'subHeadLoadGoogleFonts'  => false,
							'contentLoadGoogleFonts'  => false,
							'contentFontFamily'       => '',
							'contentFontWeight'       => '',
							'contentFontSubset'       => '',
							'contentFontSizeType'     => '',
							'contentLineHeightType'   => 'em',
							'contentFontSize'         => 'px',
							'contentFontSizeTablet'   => '',
							'contentFontSizeMobile'   => '',
							'contentLineHeight'       => '',
							'contentLineHeightTablet' => '',
							'contentLineHeightMobile' => '',
							'contentVrPadding'        => '',
							'contentHrPadding'        => '',
							'authorColor'             => '',
							'summaryColor'            => '',
							'starActiveColor'         => '',
							'starOutlineColor'        => '',
						),
					),
					'uagb/restaurant-menu-child'  => array(
						'slug'        => '',
						'title'       => __( 'Price List-Child', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to add attractive Price List.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'     => false,
							'childMigrate'     => false,
							'block_id'         => '',
							'headingAlign'     => 'left',
							'imagePosition'    => 'top',
							'imageAlignment'   => 'top',
							'imgVrPadding'     => 0,
							'imgHrPadding'     => 0,
							'imgTopPadding'    => 0,
							'imgBottomPadding' => 0,
							'iconImage'        => '',
							'imageSize'        => 'medium',
							'imageWidth'       => '',
							'columns'          => 2,
							'tcolumns'         => 2,
							'mcolumns'         => 1,
							'rowGap'           => 10,
							'columnGap'        => 10,
							'contentHrPadding' => 5,
							'contentVrPadding' => 5,

						),
					),
					'uagb/section'                => array(
						'slug'        => '',
						'title'       => __( 'Section', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block is an outer wrap section that allows you to add other blocks within it.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'             => false,
							'topPadding'               => '20',
							'bottomPadding'            => '20',
							'leftPadding'              => '20',
							'rightPadding'             => '20',
							'topMargin'                => '0',
							'bottomMargin'             => '0',
							'leftMargin'               => '0',
							'rightMargin'              => '0',
							'topPaddingTablet'         => '',
							'bottomPaddingTablet'      => '',
							'leftPaddingTablet'        => '',
							'rightPaddingTablet'       => '',
							'topPaddingMobile'         => '',
							'bottomPaddingMobile'      => '',
							'leftPaddingMobile'        => '',
							'rightPaddingMobile'       => '',
							'topMarginMobile'          => '',
							'bottomMarginMobile'       => '',
							'leftMarginMobile'         => '',
							'rightMarginMobile'        => '',
							'topMarginTablet'          => '',
							'bottomMarginTablet'       => '',
							'leftMarginTablet'         => '',
							'rightMarginTablet'        => '',
							'contentWidth'             => 'boxed',
							'width'                    => '900',
							'innerWidth'               => '1140',
							'innerWidthType'           => 'px',
							'tag'                      => 'section',
							'backgroundType'           => 'none',
							'gradientColor1'           => '',
							'gradientColor2'           => '',
							'backgroundVideoColor'     => '',
							'backgroundPosition'       => 'center-center',
							'backgroundSize'           => 'cover',
							'backgroundRepeat'         => 'no-repeat',
							'backgroundAttachment'     => 'scroll',
							'gradientType'             => 'linear',
							'gradientLocation1'        => '0',
							'gradientLocation2'        => '100',
							'gradientAngle'            => '0',
							'gradientPosition'         => 'center center',
							'backgroundColor'          => '',
							'backgroundOpacity'        => '',
							'backgroundVideoOpacity'   => '50',
							'backgroundImageColor'     => '',
							'align'                    => 'center',
							'borderStyle'              => 'none',
							'borderWidth'              => '1',
							'borderRadius'             => '',
							'borderColor'              => '',
							'themeWidth'               => false,
							'mobileMarginType'         => 'px',
							'tabletMarginType'         => 'px',
							'desktopMarginType'        => 'px',
							'mobilePaddingType'        => 'px',
							'tabletPaddingType'        => 'px',
							'desktopPaddingType'       => 'px',
							'overlayType'              => 'color',
							'gradientOverlayColor1'    => '',
							'gradientOverlayColor2'    => '',
							'gradientOverlayType'      => 'linear',
							'gradientOverlayLocation1' => '0',
							'gradientOverlayLocation2' => '100',
							'gradientOverlayAngle'     => '0',
							'gradientOverlayPosition'  => 'center center',
							'boxShadowColor'           => '',
							'boxShadowHOffset'         => 0,
							'boxShadowVOffset'         => 0,
							'boxShadowBlur'            => '',
							'boxShadowSpread'          => '',
							'boxShadowPosition'        => 'outset',
							'gradientValue'            => '',
						),
					),
					'uagb/social-share'           => array(
						'slug'        => '',
						'title'       => __( 'Social Share', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to let users share your content across various social networking sites.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'  => false,
							'childMigrate'  => false,
							'align'         => 'center',
							'social_count'  => '1',
							'socials'       => array(
								array(
									'type'                => 'facebook',
									'image_icon'          => 'icon',
									'icon'                => 'fab fa-facebook',
									'image'               => '',
									'icon_color'          => '#3a3a3a',
									'icon_hover_color'    => '#3a3a3a',
									'icon_bg_color'       => '',
									'icon_bg_hover_color' => '',
								),
							),
							'gap'           => '10',
							'size'          => '40',
							'sizeType'      => 'px',
							'sizeMobile'    => '',
							'sizeTablet'    => '',
							'bgSize'        => '0',
							'bgSizeType'    => 'px',
							'bgSizeMobile'  => '',
							'bgSizeTablet'  => '',
							'borderRadius'  => '0',
							'social_layout' => 'horizontal',
							'stack'         => 'none',
						),
					),
					'uagb/social-share-child'     => array(
						'slug'        => '',
						'title'       => __( 'Social Share Child', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place an image or icon in a list format.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'extension'   => false,
						'attributes'  => array(
							'type'                => 'facebook',
							'image_icon'          => 'icon',
							'icon'                => 'fab fa-facebook',
							'image'               => '',
							'icon_color'          => '#3a3a3a',
							'icon_hover_color'    => '',
							'icon_bg_color'       => '',
							'icon_bg_hover_color' => '',
						),
					),
					'uagb/tabs'                   => array(
						'slug'        => '',
						'title'       => __( 'Tabs', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to display your content in tabs layout.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-tabs-js' ),
						'attributes'  => array(
							'tabHeaders'            => array( 'Tab 1', 'Tab 2', 'Tab 3' ),
							'tabAlign'              => 'left',
							'tabActive'             => 0,
							'tabActiveFrontend'     => 0,
							'tabsStyleD'            => 'hstyle1',
							'tabsStyleT'            => 'vstyle6',
							'tabsStyleM'            => 'vstyle6',
							'headerBgColor'         => '',
							'headerTextColor'       => '#007cba',
							'bodyBgColor'           => '',
							'bodyTextColor'         => '',
							'borderWidth'           => 1,
							'borderColor'           => '#e0e0e0',
							'borderRadius'          => '',
							'activeTabBgColor'      => '#007cba',
							'activeTabTextColor'    => '#fff',
							'activeiconColor'       => '#fff',
							'tabTitleLeftMargin'    => '',
							'tabTitleRightMargin'   => '',
							'tabTitleTopMargin'     => '',
							'tabTitleBottomMargin'  => '',
							'tabBodyLeftMargin'     => '',
							'tabBodyRightMargin'    => '',
							'tabBodyTopMargin'      => '',
							'tabBodyBottomMargin'   => '',
							'tabBodyVertPadding'    => '',
							'tabBodyHrPadding'      => '',
							'tabTitleVertPadding'   => '',
							'tabTitleHrPadding'     => '',
							'titleFontSize'         => '',
							'titleFontSizeType'     => 'px',
							'titleFontSizeTablet'   => '',
							'titleFontSizeMobile'   => '',
							'titleFontFamily'       => 'Default',
							'titleFontWeight'       => '',
							'titleFontSubset'       => '',
							'titleLineHeightType'   => 'em',
							'titleLineHeight'       => '',
							'titleLineHeightTablet' => '',
							'titleLineHeightMobile' => '',
							'titleLoadGoogleFonts'  => false,
							'titleAlign'            => 'center',
							'showIcon'              => false,
							'icon'                  => '',
							'iconColor'             => '',
							'iconSize'              => 12,
							'iconPosition'          => 'left',
							'iconSpacing'           => 10,
						),
					),
					'uagb/tabs-child'             => array(
						'slug'        => '',
						'title'       => __( 'Tabs child', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to display your content in tabs layout.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'is_child'    => true,
						'attributes'  => array(
							'block_id'   => '',
							'id'         => 0, // Unique Tab Body ID.
							'header'     => '',
							'tabActive'  => 0,
							'tabHeaders' => '',
						),
					),
					'uagb/table-of-contents'      => array(
						'slug'        => '',
						'title'       => __( 'Table of Contents', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to place a Table of Contents for Pages/Posts.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-table-of-contents' ),
						'attributes'  => array(
							'classMigrate'              => false,
							'block_id'                  => '',
							'heading'                   => __( 'Table Of Contents', 'ultimate-addons-for-gutenberg' ),
							'emptyHeadingTeaxt'         => __( 'Add a header to begin generating the table of contents', 'ultimate-addons-for-gutenberg' ),
							'disableBullets'            => false,
							'smoothScroll'              => true,
							'smoothScrollOffset'        => 30,
							'scrollToTop'               => false,
							'scrollToTopColor'          => '',
							'scrollToTopBgColor'        => '',
							'considerH1'                => true,
							'considerH2'                => true,
							'considerH3'                => true,
							'considerH4'                => true,
							'considerH5'                => true,
							'considerH6'                => true,
							'customWidth'               => false,
							'widthDesktop'              => 100,
							'widthTablet'               => '',
							'widthMobile'               => '',
							'tColumnsDesktop'           => 1,
							'tColumnsTablet'            => 1,
							'tColumnsMobile'            => 1,
							'mappingHeaders'            => array_fill_keys( array( 0, 1, 2, 3, 4, 5 ), true ),
							'widthTypeDesktop'          => '%',
							'widthTypeTablet'           => '%',
							'widthTypeMobile'           => '%',
							'makeCollapsible'           => false,
							'initialCollapse'           => false,
							'icon'                      => 'fa-angle-down',
							'iconColor'                 => '',
							'bulletColor'               => '',
							'iconSize'                  => '',
							'align'                     => 'left',
							'linkColor'                 => '#333',
							'vPaddingDesktop'           => 30,
							'vPaddingTablet'            => '',
							'vPaddingMobile'            => '',
							'hPaddingDesktop'           => 30,
							'hPaddingTablet'            => '',
							'hPaddingMobile'            => '',
							'paddingTypeDesktop'        => 'px',
							'paddingTypeTablet'         => 'px',
							'paddingTypeMobile'         => 'px',
							'vMarginDesktop'            => '',
							'vMarginTablet'             => '',
							'vMarginMobile'             => '',
							'hMarginDesktop'            => '',
							'hMarginTablet'             => '',
							'hMarginMobile'             => '',
							'marginTypeDesktop'         => 'px',
							'marginTypeTablet'          => 'px',
							'marginTypeMobile'          => 'px',
							'contentPaddingDesktop'     => '',
							'contentPaddingTablet'      => '',
							'contentPaddingMobile'      => '',
							'contentPaddingTypeDesktop' => 'px',
							'contentPaddingTypeTablet'  => 'px',
							'contentPaddingTypeMobile'  => 'px',
							'headingBottom'             => '',
							'backgroundColor'           => '#eee',
							'linkHoverColor'            => '',
							'headingColor'              => '',
							'borderStyle'               => 'solid',
							'borderWidth'               => 1,
							'borderRadius'              => '',
							'borderColor'               => '#333',
							'loadGoogleFonts'           => false,
							'fontFamily'                => '',
							'fontWeight'                => '',
							'fontSubset'                => '',
							'fontSize'                  => '',
							'fontSizeType'              => 'px',
							'fontSizeTablet'            => '',
							'fontSizeMobile'            => '',
							'lineHeightType'            => 'em',
							'lineHeight'                => '',
							'lineHeightTablet'          => '',
							'lineHeightMobile'          => '',
							'headingLoadGoogleFonts'    => false,
							'headingFontFamily'         => '',
							'headingFontWeight'         => '500',
							'headingFontSubset'         => '',
							'headingFontSize'           => 20,
							'headingFontSizeType'       => 'px',
							'headingFontSizeTablet'     => '',
							'headingFontSizeMobile'     => '',
							'headingLineHeightType'     => 'em',
							'headingLineHeight'         => '',
							'headingLineHeightTablet'   => '',
							'headingLineHeightMobile'   => '',
							'headingAlignment'          => 'left',
						),
					),
					'uagb/team'                   => array(
						'slug'        => '',
						'title'       => __( 'Team', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allows you to display your team. Add their picture, name, what they do and links to their social profiles.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'classMigrate'           => false,
							'block_id'               => '',
							'align'                  => 'center',
							'tag'                    => 'h3',
							'titleColor'             => '',
							'prefixColor'            => '#888888',
							'descColor'              => '',
							'socialColor'            => '#333',
							'socialHoverColor'       => '',
							'titleFontFamily'        => '',
							'titleLoadGoogleFonts'   => false,
							'titleFontWeight'        => '',
							'titleFontSubset'        => '',
							'titleFontSize'          => '',
							'titleFontSizeType'      => 'px',
							'titleFontSizeTablet'    => '',
							'titleFontSizeMobile'    => '',
							'titleLineHeight'        => '',
							'titleLineHeightType'    => 'em',
							'titleLineHeightTablet'  => '',
							'titleLineHeightMobile'  => '',
							'prefixFontFamily'       => '',
							'prefixLoadGoogleFonts'  => false,
							'prefixFontWeight'       => '',
							'prefixFontSubset'       => '',
							'prefixFontSize'         => 15,
							'prefixFontSizeType'     => 'px',
							'prefixFontSizeTablet'   => '',
							'prefixFontSizeMobile'   => '',
							'prefixLineHeight'       => '',
							'prefixLineHeightType'   => 'em',
							'prefixLineHeightTablet' => '',
							'prefixLineHeightMobile' => '',
							'descFontFamily'         => '',
							'descLoadGoogleFonts'    => false,
							'descFontWeight'         => '',
							'descFontSubset'         => '',
							'descFontSize'           => 15,
							'descFontSizeType'       => 'px',
							'descFontSizeTablet'     => '',
							'descFontSizeMobile'     => '',
							'descLineHeight'         => '',
							'descLineHeightType'     => 'em',
							'descLineHeightTablet'   => '',
							'descLineHeightMobile'   => '',
							'socialFontSize'         => 20,
							'socialFontSizeType'     => 'px',
							'socialFontSizeMobile'   => '',
							'socialFontSizeTablet'   => '',
							'image'                  => '',
							'imgStyle'               => 'normal',
							'imgPosition'            => 'above',
							'imgAlign'               => 'top',
							'imgSiz'                 => 'thumbnail',
							'imgWidth'               => 120,
							'titleSpace'             => '',
							'prefixSpace'            => '',
							'descSpace'              => 10,
							'imgLeftMargin'          => 20,
							'imgRightMargin'         => 20,
							'imgTopMargin'           => 15,
							'imgBottomMargin'        => 15,
							'socialSpace'            => 20,
							'headingTag'             => 'h3',
						),
					),
					'uagb/testimonial'            => array(
						'slug'        => '',
						'title'       => __( 'Testimonial', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps your display some amazing client feedback within your website.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'js_assets'   => array( 'uagb-slick-js' ),
						'css_assets'  => array( 'uagb-slick-css' ),
						'attributes'  => array(
							'classMigrate'            => false,
							'headingAlign'            => 'center',
							'companyColor'            => '#888888',
							'descColor'               => '#333',
							'authorColor'             => '#333',
							'nameFontSizeType'        => 'px',
							'nameFontSize'            => '',
							'nameFontSizeTablet'      => '',
							'nameFontSizeMobile'      => '',
							'nameFontFamily'          => '',
							'nameFontWeight'          => '',
							'nameFontSubset'          => '',
							'nameLineHeightType'      => 'em',
							'nameLineHeight'          => '',
							'nameLineHeightTablet'    => '',
							'nameLineHeightMobile'    => '',
							'nameLoadGoogleFonts'     => false,
							'companyFontSizeType'     => 'px',
							'companyFontSize'         => '',
							'companyFontSizeTablet'   => '',
							'companyFontSizeMobile'   => '',
							'companyFontFamily'       => '',
							'companyFontWeight'       => '',
							'companyFontSubset'       => '',
							'companyLineHeightType'   => 'em',
							'companyLineHeight'       => '',
							'companyLineHeightTablet' => '',
							'companyLineHeightMobile' => '',
							'companyLoadGoogleFonts'  => false,
							'descFontSizeType'        => 'px',
							'descFontSize'            => '',
							'descFontSizeTablet'      => '',
							'descFontSizeMobile'      => '',
							'descFontFamily'          => '',
							'descFontWeight'          => '',
							'descFontSubset'          => '',
							'descLineHeightType'      => 'em',
							'descLineHeight'          => '',
							'descLineHeightTablet'    => '',
							'descLineHeightMobile'    => '',
							'descLoadGoogleFonts'     => false,
							'descSpace'               => 15,
							'block_id'                => '',
							'nameSpace'               => 5,
							'imgVrPadding'            => 10,
							'imgHrPadding'            => 10,
							'imageWidth'              => 60,
							'rowGap'                  => 10,
							'columnGap'               => 10,
							'contentPadding'          => 5,
							'backgroundColor'         => '',
							'backgroundImage'         => '',
							'backgroundPosition'      => 'center-center',
							'backgroundSize'          => 'cover',
							'backgroundRepeat'        => 'no-repeat',
							'backgroundImageColor'    => '',
							'backgroundOpacity'       => 0,
							'borderStyle'             => 'none',
							'borderWidth'             => 1,
							'borderRadius'            => 0,
							'borderColor'             => '#333',
							'arrowColor'              => '#333',
							'arrowDots'               => 'arrowDots',
							'arrowBorderSize'         => 1,
							'arrowBorderRadius'       => 0,
							'columns'                 => 1,
							'autoplaySpeed'           => 2000,
							'autoplay'                => true,
							'infiniteLoop'            => true,
							'pauseOnHover'            => true,
							'transitionSpeed'         => 500,
							'tcolumns'                => 1,
							'mcolumns'                => 1,
							'arrowSize'               => 20,
							'test_item_count'         => 3,
						),
					),
					'uagb/wp-search'              => array(
						'slug'        => '',
						'title'       => __( 'WP - Search', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you add a Search field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'extension'   => false,
						'attributes'  => array(
							'block_id'                => '',
							'layout'                  => 'input-button',
							'placeholder'             => 'Type & Hit Enter',
							'inputSize'               => 100,
							'textColor'               => '',
							'inputBgColor'            => '#ECEEEF',
							'boxShadowColor'          => '',
							'boxShadowHOffset'        => 0,
							'boxShadowVOffset'        => 0,
							'boxShadowBlur'           => '',
							'boxShadowSpread'         => '',
							'boxShadowPosition'       => 'outset',
							'borderStyle'             => 'none',
							'borderWidth'             => '',
							'borderRadius'            => 3,
							'borderColor'             => '',
							'buttonBgColor'           => '#9d9d9d',
							'buttonBgHoverColor'      => '',
							'buttonIconColor'         => '',
							'buttonIconHoverColor'    => '',
							'buttonWidth'             => 55,
							'buttonIconSize'          => 17,
							'iconColor'               => '',
							'iconSize'                => 17,
							'inputloadGoogleFonts'    => false,
							'inputFontFamily'         => 'Default',
							'inputFontWeight'         => '',
							'inputFontSubset'         => '',
							'inputFontSize'           => '',
							'inputFontSizeType'       => 'px',
							'inputFontSizeTablet'     => '',
							'inputFontSizeMobile'     => '',
							'inputLineHeight'         => '',
							'inputLineHeightType'     => 'em',
							'inputLineHeightTablet'   => '',
							'inputLineHeightMobile'   => '',
							'inputPaddingTypeDesktop' => 'px',
							'vinputPaddingMobile'     => 15,
							'vinputPaddingTablet'     => 15,
							'vinputPaddingDesktop'    => 15,
							'hinputPaddingMobile'     => 13,
							'hinputPaddingTablet'     => 13,
							'hinputPaddingDesktop'    => 13,
							'buttonType'              => 'icon',
							'buttonText'              => 'Search',
							'buttonloadGoogleFonts'   => 'false',
							'buttonFontFamily'        => 'Default',
							'buttonFontWeight'        => '',
							'buttonFontSubset'        => '',
							'buttonFontSize'          => '',
							'buttonFontSizeType'      => 'px',
							'buttonFontSizeTablet'    => '',
							'buttonFontSizeMobile'    => '',
							'buttonLineHeight'        => '',
							'buttonLineHeightType'    => 'em',
							'buttonLineHeightTablet'  => '',
							'buttonLineHeightMobile'  => '',
							'buttonTextColor'         => '#313131',
							'buttonTextHoverColor'    => '',
							'inputSizeType'           => '%',
						),
					),
					'uagb/taxonomy-list'          => array(
						'slug'        => '',
						'title'       => __( 'Taxonomy List', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you to display content categorization for various post types', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'attributes'  => array(
							'block_id'              => '',
							'postType'              => 'post',
							'taxonomyType'          => 'category',
							'titleTag'              => '',
							'categories'            => '',
							'order'                 => 'desc',
							'orderBy'               => 'date',
							'postsToShow'           => 8,
							'layout'                => 'grid',
							'columns'               => 3,
							'tcolumns'              => 2,
							'mcolumns'              => 1,
							'bgColor'               => '#f5f5f5',
							'titleColor'            => '#3b3b3b',
							'countColor'            => '#777777',
							'listTextColor'         => '#3b3b3b',
							'hoverlistTextColor'    => '#3b3b3b',
							'listStyleColor'        => '#3b3b3b',
							'hoverlistStyleColor'   => '#3b3b3b',
							'rowGap'                => 20,
							'columnGap'             => 20,
							'contentPadding'        => 20,
							'contentPaddingMobile'  => 15,
							'contentPaddingTablet'  => 15,
							'titleBottomSpace'      => 15,
							'listBottomMargin'      => 10,
							'alignment'             => 'center',
							'listStyle'             => 'disc',
							'seperatorStyle'        => 'none',
							'seperatorWidth'        => 100,
							'seperatorThickness'    => 1,
							'seperatorColor'        => '#b2b4b5',
							'boxShadowColor'        => '',
							'boxShadowHOffset'      => 0,
							'boxShadowVOffset'      => 0,
							'boxShadowBlur'         => '',
							'boxShadowSpread'       => '',
							'boxShadowPosition'     => 'outset',
							'titleFontSize'         => '',
							'titleFontSizeType'     => 'px',
							'titleFontSizeMobile'   => '',
							'titleFontSizeTablet'   => '',
							'titleFontFamily'       => '',
							'titleFontWeight'       => '',
							'titleFontSubset'       => '',
							'titleLineHeightType'   => 'em',
							'titleLineHeight'       => '',
							'titleLineHeightTablet' => '',
							'titleLineHeightMobile' => '',
							'titleLoadGoogleFonts'  => false,
							'countFontSize'         => '',
							'countFontSizeType'     => 'px',
							'countFontSizeMobile'   => '',
							'countFontSizeTablet'   => '',
							'countFontFamily'       => '',
							'countFontWeight'       => '',
							'countFontSubset'       => '',
							'countLineHeightType'   => 'em',
							'countLineHeight'       => '',
							'countLineHeightTablet' => '',
							'countLineHeightMobile' => '',
							'countLoadGoogleFonts'  => false,
							'listFontSize'          => '',
							'listFontSizeType'      => 'px',
							'listFontSizeMobile'    => '',
							'listFontSizeTablet'    => '',
							'listFontFamily'        => '',
							'listFontWeight'        => '',
							'listFontSubset'        => '',
							'listLineHeightType'    => 'em',
							'listLineHeight'        => '',
							'listLineHeightTablet'  => '',
							'listLineHeightMobile'  => '',
							'listLoadGoogleFonts'   => false,
							'borderStyle'           => 'solid',
							'borderThickness'       => 1,
							'borderRadius'          => 0,
							'borderColor'           => '#E0E0E0',
							'noTaxDisplaytext'      => __( 'Taxonomy Not Available.', 'ultimate-addons-for-gutenberg' ),
							'showCount'             => true,
							'showEmptyTaxonomy'     => false,
							'showhierarchy'         => false,
							'listDisplayStyle'      => 'list',
						),
					),
					'uagb/forms'                  => array(
						'slug'        => '',
						'title'       => __( 'Forms', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block allow you to create interactive contact form, newsletter, suggestion, etc easily.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'js_assets'   => array( 'uagb-forms-js' ),
						'attributes'  => array(
							'block_id'                   => '',
							'submitButtonText'           => __( 'Submit', 'ultimate-addons-for-gutenberg' ),
							'formLabel'                  => __( 'UAG Form', 'ultimate-addons-for-gutenberg' ),
							'buttonAlign'                => 'left',
							'confirmationType'           => 'message',
							'confirmationMessage'        => __( 'The form has been submitted Successfully!', 'ultimate-addons-for-gutenberg' ),
							'confirmationUrl'            => '',
							'buttonSize'                 => 'medium',
							'submitColor'                => '#ffffff',
							'submitColorHover'           => '#000000',
							'submitBgColor'              => '#000000',
							'submitBgColorHover'         => '#ffffff',
							'submitborderStyle'          => '',
							'toggleSize'                 => 15,
							'toggleActiveColor'          => '#000000',
							'toggleWidthSize'            => 0,
							'toggleHeightSize'           => 0,
							'submitborderWidth'          => 0,
							'submitborderRadius'         => 3,
							'submitborderColor'          => '',
							'submitborderHoverColor'     => '',
							'vPaddingSubmit'             => '',
							'hPaddingSubmit'             => '',
							'submitTextloadGoogleFonts'  => false,
							'sendAfterSubmitEmail'       => true,
							'afterSubmitToEmail'         => '',
							'afterSubmitBccEmail'        => '',
							'afterSubmitCcEmail'         => '',
							'afterSubmitEmailSubject'    => __( 'Form Submission', 'ultimate-addons-for-gutenberg' ),
							'submitTextFontFamily'       => 'Default',
							'submitTextFontWeight'       => '',
							'submitTextFontSubset'       => '',
							'submitTextFontSize'         => 15,
							'submitTextFontSizeType'     => 'px',
							'submitTextFontSizeTablet'   => 15,
							'submitTextFontSizeMobile'   => 15,
							'submitTextLineHeight'       => '',
							'submitTextLineHeightType'   => 'em',
							'submitTextLineHeightTablet' => '',
							'submitTextLineHeightMobile' => '',
							'labelloadGoogleFonts'       => false,
							'labelFontFamily'            => 'Default',
							'labelFontWeight'            => '',
							'labelFontSubset'            => '',
							'labelFontSize'              => 15,
							'labelFontSizeType'          => 'px',
							'labelFontSizeTablet'        => 15,
							'labelFontSizeMobile'        => 15,
							'labelLineHeight'            => '',
							'labelLineHeightType'        => 'em',
							'labelLineHeightTablet'      => '',
							'labelLineHeightMobile'      => '',
							'inputloadGoogleFonts'       => false,
							'inputFontFamily'            => 'Default',
							'inputFontWeight'            => '',
							'inputFontSubset'            => '',
							'inputFontSize'              => '',
							'inputFontSizeType'          => 'px',
							'inputFontSizeTablet'        => '',
							'inputFontSizeMobile'        => '',
							'inputLineHeight'            => '',
							'inputLineHeightType'        => 'em',
							'inputLineHeightTablet'      => '',
							'inputLineHeightMobile'      => '',
							'labelColor'                 => '#000000',
							'inputColor'                 => '#000000',
							'bgColor'                    => '',
							'inputplaceholderColor'      => '#abb8c3',
							'inputactiveColor'           => '#000000',
							'inputborderStyle'           => 'solid',
							'inputborderWidth'           => 1,
							'inputborderRadius'          => 3,
							'inputborderColor'           => '#BDBDBD',
							'inputborderHoverColor'      => '',
							'vPaddingField'              => 10,
							'hPaddingField'              => 10,
							'fieldGap'                   => 20,
							'formStyle'                  => 'boxed',
							'overallAlignment'           => 'left',
							'successMessageTextColor'    => '#000000',
							'successMessageBGColor'      => '#00800030',
							'successMessageBorderColor'  => 'green',
							'successMessageBorderStyle'  => 'solid',
							'successMessageBorderWidth'  => 2,
							'failedMessage'              => __( 'There has been some error while submitting the form. Please verify all form fields again.', 'ultimate-addons-for-gutenberg' ),
							'failedMessageTextColor'     => '#000000',
							'failedMessageBorderColor'   => 'red',
							'failedMessageBGColor'       => '#f5f5f',
							'failedMessageBorderStyle'   => 'solid',
							'failedMessageBorderWidth'   => 2,
							'reCaptchaEnable'            => false,
							'reCaptchaType'              => 'v2',
							'reCaptchaSiteKeyV2'         => '',
							'reCaptchaSecretKeyV2'       => '',
							'reCaptchaSiteKeyV3'         => '',
							'reCaptchaSecretKeyV3'       => '',
							'hidereCaptchaBatch'         => false,
							'captchaMessage'             => __( 'Please fill up the above captcha.', 'ultimate-addons-for-gutenberg' ),
						),
					),
					'uagb/forms-name'             => array(
						'slug'        => '',
						'title'       => __( 'Name', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Name field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-email'            => array(
						'slug'        => '',
						'title'       => __( 'Email', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Email field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-hidden'           => array(
						'slug'        => '',
						'title'       => __( 'Hidden', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Hidden field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(
							'block_id'           => '',
							'hidden_field_name'  => __( 'Hidden Field Name', 'ultimate-addons-for-gutenberg' ),
							'hidden_field_value' => '',

						),
					),
					'uagb/forms-phone'            => array(
						'slug'        => '',
						'title'       => __( 'Phone', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Phone field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-textarea'         => array(
						'slug'        => '',
						'title'       => __( 'Textarea', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Textarea field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(
							'block_id'     => '',
							'textareaName' => __( 'Message', 'ultimate-addons-for-gutenberg' ),
							'rows'         => '4',
						),
					),
					'uagb/forms-checkbox'         => array(
						'slug'        => '',
						'title'       => __( 'Checkbox', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Checkbox field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-radio'            => array(
						'slug'        => '',
						'title'       => __( 'Radio', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Radio field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-url'              => array(
						'slug'        => '',
						'title'       => __( 'URL', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add URL field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(
							'block_id' => '',
							'name'     => __( 'URL', 'ultimate-addons-for-gutenberg' ),
						),
					),
					'uagb/forms-select'           => array(
						'slug'        => '',
						'title'       => __( 'Select', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Select field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-toggle'           => array(
						'slug'        => '',
						'title'       => __( 'Toggle', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Toggle field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-date'             => array(
						'slug'        => '',
						'title'       => __( 'Datepicker', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Datepicker field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'is_child'    => true,
						'attributes'  => array(),
					),
					'uagb/forms-accept'           => array(
						'slug'        => '',
						'title'       => __( 'Accept', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps to add Accept field.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'attributes'  => array(),
					),
					'uagb/lottie'                 => array(
						'slug'        => '',
						'title'       => __( 'Lottie', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you add Lottie animation and customize it as required.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'js_assets'   => array( 'uagb-lottie-js', 'uagb-bodymovin-min' ),
						'attributes'  => array(
							'block_id'         => '',
							'jsonLottie'       => '',
							'lottieURl'        => '',
							'height'           => '',
							'heightTablet'     => '',
							'heightMob'        => '',
							'width'            => '',
							'widthTablet'      => '',
							'widthMob'         => '',
							'backgroundColor'  => '',
							'backgroundHColor' => '',
							'loop'             => true,
							'speed'            => 1,
							'reverse'          => false,
							'playOn'           => 'none',
						),
					),
					'uagb/star-rating'            => array(
						'slug'        => '',
						'title'       => __( 'Star Rating', 'ultimate-addons-for-gutenberg' ),
						'description' => __( 'This block helps you add Star Rating and customize it as required.', 'ultimate-addons-for-gutenberg' ),
						'default'     => true,
						'js_assets'   => array(),
						'attributes'  => array(
							'block_id'         => '',
							'range'            => '5',
							'rating'           => '4',
							'size'             => '',
							'align'            => 'left',
							'layout'           => 'inline',
							'gap'              => '',
							'unmarkedColor'    => '#ccd6df',
							'color'            => '#f0ad4e',
							'fontFamily'       => 'Default',
							'fontWeight'       => '',
							'fontSubset'       => '',
							'fontSizeType'     => 'px',
							'fontSize'         => '',
							'fontSizeMobile'   => '',
							'fontSizeTablet'   => '',
							'lineHeightType'   => 'em',
							'lineHeight'       => '',
							'lineHeightMobile' => '',
							'lineHeightTablet' => '',
							'titleColor'       => '',
							'titleGap'         => '10',
						),
					),
				);
			}
			return self::$block_attributes;
		}

		/**
		 * Get Block Assets.
		 *
		 * @since 1.13.4
		 *
		 * @return array The Asset List.
		 */
		public static function get_block_assets() {

			$blocks      = UAGB_Admin_Helper::get_block_options();
			$post_js_dep = ( ( false === $blocks['uagb/post-carousel']['is_activate'] ) ? array( 'jquery' ) : array( 'jquery', 'uagb-slick-js' ) );

			if ( null === self::$block_assets ) {
				self::$block_assets = array(
					'uagb-timeline-js'       => array(
						'src' => UAGB_URL . 'assets/js/timeline.js',
						'dep' => array( 'jquery' ),
					),
					'uagb-masonry'           => array(
						'src' => UAGB_URL . 'assets/js/isotope.min.js',
						'dep' => array( 'jquery' ),
					),
					'uagb-imagesloaded'      => array(
						'src' => UAGB_URL . 'assets/js/imagesloaded.min.js',
						'dep' => array( 'jquery' ),
					),
					'uagb-table-of-contents' => array(
						'src' => UAGB_URL . 'assets/js/table-of-contents.js',
						'dep' => array( 'jquery' ),
					),
					'uagb-slick-js'          => array(
						'src' => UAGB_URL . 'assets/js/slick.min.js',
						'dep' => array( 'jquery' ),
					),
					'uagb-slick-css'         => array(
						'src' => UAGB_URL . 'assets/css/slick.css',
						'dep' => array(),
					),
					'uagb-post-js'           => array(
						'src' => UAGB_URL . 'assets/js/post.js',
						'dep' => $post_js_dep,
					),
					'uagb-faq-js'            => array(
						'src'        => UAGB_URL . 'assets/js/faq.js',
						'dep'        => array(),
						'skipEditor' => true,
					),
					'uagb-cookie-lib'        => array(
						'src'        => UAGB_URL . 'assets/js/js_cookie.js',
						'dep'        => array( 'jquery' ),
						'skipEditor' => true,
					),
					'uagb-inline-notice-js'  => array(
						'src'        => UAGB_URL . 'assets/js/inline-notice.js',
						'dep'        => array( 'jquery', 'uagb-cookie-lib' ),
						'skipEditor' => true,
					),
					'uagb-tabs-js'           => array(
						'src' => UAGB_URL . 'assets/js/tabs.js',
						'dep' => array( 'jquery' ),
					),
					'uagb-forms-js'          => array(
						'src' => UAGB_URL . 'assets/js/forms.js',
						'dep' => array( 'jquery' ),
					),
					'uagb-bodymovin-min'     => array(
						'src'        => UAGB_URL . 'assets/js/uagb-bodymovin.min.js',
						'dep'        => array(),
						'skipEditor' => true,
					),
					'uagb-lottie-js'         => array(
						'src'        => UAGB_URL . 'assets/js/uagb-lottie.js',
						'dep'        => array( 'jquery', 'uagb-bodymovin-min' ),
						'skipEditor' => true,
					),
				);
			}
			return self::$block_assets;
		}

		/**
		 * Get Block Assets.
		 *
		 * @since 1.23.0
		 *
		 * @return array The Asset List.
		 */
		public static function get_block_assets_css() {

			if ( null === self::$block_assets_css ) {
				self::$block_assets_css = array(
					'uagb/table-of-contents'      => array(
						'name' => 'table-of-contents',
					),
					'uagb/advanced-heading'       => array(
						'name' => 'advanced-heading',
					),
					'uagb/blockquote'             => array(
						'name' => 'blockquote',
					),
					'uagb/buttons-child'          => array(
						'name' => 'buttons-child',
					),
					'uagb/buttons'                => array(
						'name' => 'buttons',
					),
					'uagb/call-to-action'         => array(
						'name' => 'call-to-action',
					),
					'uagb/cf7-styler'             => array(
						'name' => 'cf7-styler',
					),
					'uagb/column'                 => array(
						'name' => 'column',
					),
					'uagb/columns'                => array(
						'name' => 'columns',
					),
					'uagb/faq-child'              => array(
						'name' => 'faq-child',
					),
					'uagb/faq'                    => array(
						'name' => 'faq',
					),
					'uagb/forms'                  => array(
						'name' => 'forms',
					),
					'uagb/gf-styler'              => array(
						'name' => 'gf-styler',
					),
					'uagb/google-map'             => array(
						'name' => 'google-map',
					),
					'uagb/how-to'                 => array(
						'name' => 'how-to',
					),
					'uagb/icon-list-child'        => array(
						'name' => 'icon-list-child',
					),
					'uagb/icon-list'              => array(
						'name' => 'icon-list',
					),
					'uagb/info-box'               => array(
						'name' => 'info-box',
					),
					'uagb/inline-notice'          => array(
						'name' => 'inline-notice',
					),
					'uagb/marketing-button'       => array(
						'name' => 'marketing-button',
					),
					'uagb/post-grid'              => array(
						'name' => 'post',
					),
					'uagb/post-carousel'          => array(
						'name' => 'post',
					),
					'uagb/post-masonry'           => array(
						'name' => 'post',
					),
					'uagb/restaurant-menu-child'  => array(
						'name' => 'price-list-child',
					),
					'uagb/restaurant-menu'        => array(
						'name' => 'price-list',
					),
					'uagb/review'                 => array(
						'name' => 'review',
					),
					'uagb/section'                => array(
						'name' => 'section',
					),
					'uagb/star-rating'            => array(
						'name' => 'star-rating',
					),
					'uagb/social-share-child'     => array(
						'name' => 'social-share-child',
					),
					'uagb/social-share'           => array(
						'name' => 'social-share',
					),
					'uagb/table-of-contents'      => array(
						'name' => 'table-of-contents',
					),
					'uagb/tabs-child'             => array(
						'name' => 'tabs-child',
					),
					'uagb/tabs'                   => array(
						'name' => 'tabs',
					),
					'uagb/taxonomy-list'          => array(
						'name' => 'taxonomy-list',
					),
					'uagb/team'                   => array(
						'name' => 'team',
					),
					'uagb/testimonial'            => array(
						'name' => 'testimonial',
					),
					'uagb/content-timeline'       => array(
						'name' => 'timeline',
					),
					'uagb/content-timeline-child' => array(
						'name' => 'timeline',
					),
					'uagb/post-timeline'          => array(
						'name' => 'timeline',
					),
					'uagb/wp-search'              => array(
						'name' => 'wp-search',
					),
				);
			}
			return self::$block_assets_css;
		}
	}
}

